/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.zipslip;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import io.codemodder.javaparser.JavaParserTransformer;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.SuccessOrReason;
import java.util.Optional;

final class ZipEntryStartFixStrategy
implements RemediationStrategy {
    ZipEntryStartFixStrategy() {
    }

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        MethodCallExpr call = (MethodCallExpr)node;
        Optional classDeclRef = call.findAncestor(new Class[]{ClassOrInterfaceDeclaration.class});
        if (classDeclRef.isEmpty()) {
            return SuccessOrReason.reason("No encompassing class found");
        }
        Optional methodAncestor = call.findAncestor(new Class[]{MethodDeclaration.class});
        if (methodAncestor.isEmpty()) {
            return SuccessOrReason.reason("No encompassing method found");
        }
        boolean addStatic = ((MethodDeclaration)methodAncestor.get()).isStatic() || ((ClassOrInterfaceDeclaration)classDeclRef.get()).isInterface();
        ZipEntryStartFixStrategy.addSanitizeName((ClassOrInterfaceDeclaration)classDeclRef.get(), addStatic);
        JavaParserTransformer.wrap((Expression)call).withScopelessMethod("sanitizeZipFilename");
        return SuccessOrReason.success();
    }

    private static void addSanitizeName(ClassOrInterfaceDeclaration classDecl, boolean addStatic) {
        boolean sanitizeMethodPresent;
        Object method = "String sanitizeZipFilename(String entryName) {\n    if (entryName == null || entryName.trim().isEmpty()) {\n        return entryName;\n    }\n    while (entryName.contains(\"../\") || entryName.contains(\"..\\\\\")) {\n        entryName = entryName.replace(\"../\", \"\").replace(\"..\\\\\", \"\");\n    }\n    return entryName;\n}\n";
        if (addStatic) {
            method = "static " + (String)method;
        }
        if (!(sanitizeMethodPresent = classDecl.findAll(MethodDeclaration.class).stream().anyMatch(md -> md.getNameAsString().equals("sanitizeZipFilename") && md.getParameters().size() == 1 && ((Parameter)md.getParameters().get(0)).getTypeAsString().equals("String")))) {
            classDecl.addMember((BodyDeclaration)StaticJavaParser.parseMethodDeclaration((String)method));
        }
    }

    static boolean match(Node node) {
        return Optional.of(node).map(n -> {
            MethodCallExpr mce;
            return n instanceof MethodCallExpr ? (mce = (MethodCallExpr)n) : null;
        }).filter(mce -> mce.hasScope()).filter(mce -> "getName".equals(mce.getNameAsString())).filter(mce -> mce.getParentNode().map(p -> {
            MethodCallExpr m;
            return p instanceof MethodCallExpr ? (m = (MethodCallExpr)p) : null;
        }).filter(m -> "sanitizeZipFilename".equals(m.getNameAsString())).isEmpty()).isPresent();
    }
}

