/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.sarif.appscan;

import com.google.inject.AbstractModule;
import io.codemodder.CodeChanger;
import io.codemodder.RuleSarif;
import io.codemodder.providers.sarif.appscan.ProvidedAppScanScan;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;

public final class AppScanModule
extends AbstractModule {
    private final List<Class<? extends CodeChanger>> codemodTypes;
    private final List<RuleSarif> allAppScanRuleSarifs;

    public AppScanModule(List<Class<? extends CodeChanger>> codemodTypes, List<RuleSarif> sarifs) {
        this.codemodTypes = Objects.requireNonNull(codemodTypes);
        this.allAppScanRuleSarifs = sarifs;
    }

    protected void configure() {
        Map<String, RuleSarif> map = this.allAppScanRuleSarifs.stream().collect(Collectors.toUnmodifiableMap(RuleSarif::getRule, rs -> rs));
        for (Class<? extends CodeChanger> codemodType : this.codemodTypes) {
            Constructor<?>[] constructors = codemodType.getDeclaredConstructors();
            Optional<ProvidedAppScanScan> annotation = Stream.of(constructors).filter(constructor -> constructor.getAnnotation(Inject.class) != null).flatMap(constructor -> Stream.of(constructor.getParameters())).map(parameter -> parameter.getAnnotation(ProvidedAppScanScan.class)).filter(Objects::nonNull).findFirst();
            annotation.ifPresent(providedAppScanScan -> {
                if (!providedAppScanScan.ruleName().isEmpty()) {
                    this.bind(RuleSarif.class).annotatedWith((Annotation)providedAppScanScan).toInstance((Object)map.getOrDefault(providedAppScanScan.ruleName(), RuleSarif.EMPTY));
                } else if (providedAppScanScan.ruleNames().length > 0) {
                    RuleSarif ruleSarif = RuleSarif.EMPTY;
                    for (String ruleName : providedAppScanScan.ruleNames()) {
                        RuleSarif result = (RuleSarif)map.get(ruleName);
                        if (result == null) continue;
                        ruleSarif = result;
                        break;
                    }
                    this.bind(RuleSarif.class).annotatedWith((Annotation)providedAppScanScan).toInstance((Object)ruleSarif);
                } else {
                    throw new IllegalStateException("No rule name provided in " + providedAppScanScan);
                }
            });
        }
    }
}

