/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.sarif.appscan;

import com.contrastsecurity.sarif.Location;
import com.contrastsecurity.sarif.Region;
import com.contrastsecurity.sarif.Result;
import com.contrastsecurity.sarif.SarifSchema210;
import io.codemodder.RuleSarif;
import io.codemodder.providers.sarif.appscan.AppScanSarifLocationData;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AppScanRuleSarif
implements RuleSarif {
    private final SarifSchema210 sarif;
    private final String messageText;
    private final Map<Path, List<Result>> resultsCache;
    private final AppScanSarifLocationData sarifLocationData;
    static final String toolName = "HCL AppScan Static Analyzer";
    private static final Logger log = LoggerFactory.getLogger(AppScanRuleSarif.class);

    AppScanRuleSarif(String messageText, SarifSchema210 sarif, AppScanSarifLocationData sarifLocationData) {
        this.sarif = Objects.requireNonNull(sarif);
        this.messageText = Objects.requireNonNull(messageText);
        this.resultsCache = new HashMap<Path, List<Result>>();
        this.sarifLocationData = Objects.requireNonNull(sarifLocationData);
    }

    public List<Region> getRegionsFromResultsByRule(Path path) {
        List<Result> resultsByLocationPath = this.getResultsByLocationPath(path);
        return resultsByLocationPath.stream().map(result -> ((Location)result.getLocations().get(0)).getPhysicalLocation().getRegion()).toList();
    }

    public List<Result> getResultsByLocationPath(Path path) {
        Map<Path, Set<Integer>> artifactLocationIndices = this.sarifLocationData.getArtifactLocationIndices();
        return this.resultsCache.computeIfAbsent(path, p -> this.sarif.getRuns().stream().flatMap(run -> run.getResults().stream()).filter(result -> result.getMessage().getText().equals(this.messageText)).filter(result -> artifactLocationIndices.get(path) != null && artifactLocationIndices.getOrDefault(path, Set.of()).contains(((Location)result.getLocations().get(0)).getPhysicalLocation().getArtifactLocation().getIndex())).toList());
    }

    public String getDriver() {
        return toolName;
    }

    public SarifSchema210 rawDocument() {
        return this.sarif;
    }

    public String getRule() {
        return this.messageText;
    }
}

