/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.sarif.appscan;

import com.contrastsecurity.sarif.Artifact;
import com.contrastsecurity.sarif.ArtifactLocation;
import com.contrastsecurity.sarif.Run;
import com.contrastsecurity.sarif.SarifSchema210;
import io.codemodder.CodeDirectory;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AppScanSarifLocationData {
    private final Map<Path, Set<Integer>> artifactLocationIndices;
    private static final Logger log = LoggerFactory.getLogger(AppScanSarifLocationData.class);

    AppScanSarifLocationData(SarifSchema210 sarif, CodeDirectory codeDirectory) {
        log.debug("Cleaning locations");
        List<String> locations = ((Run)sarif.getRuns().get(0)).getArtifacts().stream().map(Artifact::getLocation).map(ArtifactLocation::getUri).map(u -> u.substring(8)).toList();
        HashMap artifactLocationIndicesMap = new HashMap();
        log.debug("Calculating locations in project dir");
        for (int i = 0; i < locations.size(); ++i) {
            Optional existingRealPath;
            Integer index = i;
            String path = locations.get(i);
            path = path.replace('\\', '/');
            try {
                existingRealPath = codeDirectory.findFilesWithTrailingPath(path);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            existingRealPath.ifPresent(p -> artifactLocationIndicesMap.computeIfAbsent(p, k -> new HashSet()).add(index));
        }
        log.trace("Done calculating locations");
        this.artifactLocationIndices = Map.copyOf(artifactLocationIndicesMap);
    }

    Map<Path, Set<Integer>> getArtifactLocationIndices() {
        return this.artifactLocationIndices;
    }
}

