/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.llm;

import com.google.inject.AbstractModule;
import io.codemodder.plugins.llm.OpenAIService;

public final class LLMServiceModule
extends AbstractModule {
    private static final String TOKEN_NAME = "CODEMODDER_OPENAI_API_KEY";

    protected void configure() {
        this.bind(OpenAIService.class).toProvider(() -> new OpenAIService(this.getToken()));
    }

    private String getToken() {
        String token = System.getenv(TOKEN_NAME);
        if (token == null) {
            throw new IllegalArgumentException("CODEMODDER_OPENAI_API_KEY environment variable must be set");
        }
        return token;
    }
}

