/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.llm;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.HttpException;

class OpenAIRetryStrategy
implements Function<Flowable<? extends Throwable>, Flowable<Object>> {
    private static final int MAX_RETRY_COUNT = 3;
    private static final Logger logger = LoggerFactory.getLogger(OpenAIRetryStrategy.class);
    private int retryCount = 0;

    OpenAIRetryStrategy() {
    }

    public Flowable<Object> apply(Flowable<? extends Throwable> flowable) {
        return flowable.flatMap(e -> {
            if (++this.retryCount <= 3 && this.isRetryable((Throwable)e)) {
                logger.warn("retrying after {}s: {}", (Object)this.retryCount, e);
                return Flowable.timer((long)this.retryCount, (TimeUnit)TimeUnit.SECONDS);
            }
            return Flowable.error((Throwable)e);
        });
    }

    private boolean isRetryable(Throwable e) {
        if (e instanceof SocketTimeoutException) {
            return true;
        }
        if (e instanceof HttpException) {
            int code = ((HttpException)e).code();
            return code == 429 || code == 500 || code == 503;
        }
        return false;
    }
}

