/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.llm;

import io.codemodder.EncodingDetector;
import io.codemodder.plugins.llm.FileDescription;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DefaultFileDescription
implements FileDescription {
    private final String fileName;
    private final Charset charset;
    private final String lineSeparator;
    private final List<String> lines;

    DefaultFileDescription(Path path) {
        Objects.requireNonNull(path);
        this.fileName = path.getFileName().toString();
        try {
            this.charset = Charset.forName(EncodingDetector.create().detect(path).orElse("UTF-8"));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            String s = Files.readString(path, this.charset);
            this.lineSeparator = this.detectLineSeparator(s);
            this.lines = List.of(s.split("\\R", -1));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public String getLineSeparator() {
        return this.lineSeparator;
    }

    @Override
    public List<String> getLines() {
        return this.lines;
    }

    @Override
    public String formatLinesWithLineNumbers() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.lines.size(); ++i) {
            sb.append(i + 1);
            sb.append(": ");
            sb.append(this.lines.get(i));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String detectLineSeparator(String s) {
        Matcher m = Pattern.compile("(\\R)").matcher(s);
        if (m.find()) {
            return m.group(1);
        }
        return "\n";
    }
}

