/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.llm;

import io.codemodder.plugins.llm.Model;
import io.codemodder.plugins.llm.ModelMapper;
import io.codemodder.plugins.llm.StandardModel;
import java.util.HashMap;
import java.util.Map;

final class EnvironmentBasedModelMapper
implements ModelMapper {
    private final HashMap<Model, String> map = new HashMap();
    private static final String DEPLOYMENT_TEMPLATE = "CODEMODDER_AZURE_OPENAI_%s_DEPLOYMENT";

    EnvironmentBasedModelMapper() {
        this(System.getenv());
    }

    EnvironmentBasedModelMapper(Map<String, String> environment) {
        for (StandardModel model : StandardModel.values()) {
            String name = String.format(DEPLOYMENT_TEMPLATE, EnvironmentBasedModelMapper.toEnvironmentVariableCase(model.id()));
            String deployment = environment.getOrDefault(name, model.id());
            this.map.put(model, deployment);
        }
    }

    @Override
    public String getModelName(Model model) {
        return this.map.getOrDefault(model, model.id());
    }

    private static String toEnvironmentVariableCase(String input) {
        return input.toUpperCase().replace('-', '_').replace('.', '_');
    }
}

