/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.llm;

import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsJsonResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.ChatCompletionsResponseFormat;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.KeyCredential;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.HttpClientOptions;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.codemodder.plugins.llm.EnvironmentBasedModelMapper;
import io.codemodder.plugins.llm.Model;
import io.codemodder.plugins.llm.ModelMapper;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Objects;

public class OpenAIService {
    private final OpenAIClient api;
    private static final int TIMEOUT_SECONDS = 90;
    private final ModelMapper modelMapper;
    private boolean serviceAvailable = true;

    private static OpenAIClientBuilder builder(KeyCredential key) {
        HttpClientOptions clientOptions = new HttpClientOptions();
        clientOptions.setReadTimeout(Duration.ofSeconds(90L));
        return new OpenAIClientBuilder().retryPolicy(new RetryPolicy()).clientOptions((ClientOptions)clientOptions).credential(key);
    }

    OpenAIService(boolean serviceAvailable) {
        this.serviceAvailable = serviceAvailable;
        this.modelMapper = null;
        this.api = null;
    }

    OpenAIService(ModelMapper mapper, KeyCredential key) {
        this.modelMapper = mapper;
        this.api = OpenAIService.builder(key).buildClient();
    }

    OpenAIService(ModelMapper mapper, KeyCredential key, String endpoint) {
        this.modelMapper = mapper;
        this.api = OpenAIService.builder(key).endpoint(endpoint).buildClient();
    }

    public static OpenAIService fromOpenAI(String token) {
        return new OpenAIService(new EnvironmentBasedModelMapper(), new KeyCredential(Objects.requireNonNull(token)));
    }

    public static OpenAIService fromAzureOpenAI(String token, String endpoint) {
        return new OpenAIService(new EnvironmentBasedModelMapper(), (KeyCredential)new AzureKeyCredential(Objects.requireNonNull(token)), Objects.requireNonNull(endpoint));
    }

    public static OpenAIService noServiceAvailable() {
        return new OpenAIService(false);
    }

    public boolean isServiceAvailable() {
        return this.serviceAvailable;
    }

    public String getJSONCompletion(List<ChatRequestMessage> messages, Model modelOrDeploymentName) {
        ChatCompletionsOptions options = new ChatCompletionsOptions(messages).setTemperature(Double.valueOf(0.0)).setN(Integer.valueOf(1)).setResponseFormat((ChatCompletionsResponseFormat)new ChatCompletionsJsonResponseFormat());
        String modelName = this.modelMapper.getModelName(modelOrDeploymentName);
        ChatCompletions completions = this.api.getChatCompletions(modelName, options);
        return ((ChatChoice)completions.getChoices().get(0)).getMessage().getContent().trim();
    }

    public <T> T getResponseForPrompt(List<ChatRequestMessage> messages, Model modelName, Class<T> responseType) throws IOException {
        String json = this.getJSONCompletion(messages, modelName);
        if (json.startsWith("```json") && json.endsWith("```")) {
            json = json.substring(7, json.length() - 3);
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(json, responseType);
        }
        catch (IOException e) {
            int firstBorder = json.indexOf("```json");
            int lastBorder = json.lastIndexOf("```");
            if (firstBorder != -1 && lastBorder != -1 && lastBorder > firstBorder) {
                json = json.substring(firstBorder + 7, lastBorder);
            }
            return (T)mapper.readValue(json, responseType);
        }
    }
}

