/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.llm;

import com.azure.ai.openai.models.ChatRequestSystemMessage;
import com.azure.ai.openai.models.ChatRequestUserMessage;
import com.contrastsecurity.sarif.Location;
import com.contrastsecurity.sarif.Region;
import com.contrastsecurity.sarif.Result;
import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Patch;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.CodemodInvocationContext;
import io.codemodder.RuleSarif;
import io.codemodder.plugins.llm.BinaryThreatAnalysis;
import io.codemodder.plugins.llm.BinaryThreatAnalysisAndFix;
import io.codemodder.plugins.llm.BinaryThreatRisk;
import io.codemodder.plugins.llm.FileDescription;
import io.codemodder.plugins.llm.LLMDiffs;
import io.codemodder.plugins.llm.Model;
import io.codemodder.plugins.llm.OpenAIService;
import io.codemodder.plugins.llm.SarifPluginLLMCodemod;
import io.codemodder.plugins.llm.StandardModel;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SarifToLLMForBinaryVerificationAndFixingCodemod
extends SarifPluginLLMCodemod {
    private final Model model;
    private static final String SYSTEM_MESSAGE_TEMPLATE = "You are a security analyst bot. You are helping analyze Java code to assess its risk to a specific security threat.\n\n%s\n";
    private static final String ANALYZE_USER_MESSAGE_TEMPLATE = "A file with line numbers is provided below. Analyze it and save your threat analysis.\n\nReturn a JSON object with the following properties in this order:\n  - `analysis`: A detailed analysis of how the risk was assessed.\n  - `risk`: The risk of the security threat, either HIGH or LOW.\n--- %s\n%s\n";
    private static final String FIX_USER_MESSAGE_TEMPLATE = "A file with line numbers is provided below. Analyze it. If the risk is HIGH, use these rules to make the MINIMUM number of changes necessary to reduce the file's risk to LOW:\n- Each change MUST be syntactically correct.\n%s\n\nAny code changes to reduce the file's risk to LOW must be stored in a diff patch format. Follow these instructions when creating the patch:\n- Your output must be in the form a unified diff patch that will be applied by your coworkers.\n- The output must be similar to the output of `diff -U0`. Do not include line number ranges.\n- Start each hunk of changes with a `@@ ... @@` line.\n- Each change in a file should be a separate hunk in the diff.\n- It is very important for the change to contain only what is minimally required to fix the problem.\n- Remember that whitespace and indentation changes can be important. Preserve the original formatting and indentation. Do not replace tabs with spaces or vice versa. If the original code uses tabs, use tabs in the patch. Encode tabs using a tab literal (\\\\t). If the original code uses spaces, use spaces in the patch. Do not add spaces where none were present in the original code. **THIS IS ESPECIALLY IMPORTANT AT THE BEGINNING OF DIFF LINES.**\n- The unified diff must be accurate and complete.\n- The unified diff will be applied to the source code by your coworkers.\n\nHere's an example of a unified diff:\n```diff\n--- a/file.txt\n+++ b/file.txt\n@@ ... @@\n for (var i = 0; i < array.length; i++) {\n   This line is unchanged.\n-  This is the original line\n+  This is the replacement line\n }\n Here is another unchanged line.\n@@ ... @@\n-This line has been removed but not replaced.\n This line is unchanged.\n```\n\nNow save your threat analysis.\n\nReturn a JSON object with the following properties in this order:\n  - `analysis`: A detailed analysis of how the risk was assessed.\n  - `risk`: The risk of the security threat, either HIGH or LOW.\n  - `fixDescription`: A short description of the fix. Required if the file is fixed.\n  - `fix`: The fix as a diff patch in unified format. Required if the risk is HIGH.\n--- %s\n%s\n";
    private static final Logger logger = LoggerFactory.getLogger(SarifToLLMForBinaryVerificationAndFixingCodemod.class);

    protected SarifToLLMForBinaryVerificationAndFixingCodemod(RuleSarif sarif, OpenAIService openAI, Model model) {
        super(sarif, openAI);
        this.model = Objects.requireNonNull(model);
    }

    protected SarifToLLMForBinaryVerificationAndFixingCodemod(RuleSarif sarif, OpenAIService openAI) {
        this(sarif, openAI, StandardModel.GPT_4_TURBO_2024_04_09);
    }

    public CodemodFileScanningResult onFileFound(CodemodInvocationContext context, List<Result> results) {
        logger.debug("processing: {}", (Object)context.path());
        results.forEach(result -> {
            Region region = ((Location)result.getLocations().get(0)).getPhysicalLocation().getRegion();
            logger.debug("{}:{}", (Object)region.getStartLine(), (Object)region.getSnippet().getText());
        });
        try {
            FileDescription file = FileDescription.from(context.path());
            BinaryThreatAnalysis analysis = this.analyzeThreat(file, context, results);
            logger.debug("risk: {}", (Object)analysis.getRisk());
            logger.debug("analysis: {}", (Object)analysis.getAnalysis());
            if (analysis.getRisk() == BinaryThreatRisk.LOW) {
                return CodemodFileScanningResult.none();
            }
            BinaryThreatAnalysisAndFix fix = this.fixThreat(file, context, results);
            logger.debug("{}", (Object)fix);
            if (fix.getRisk() == BinaryThreatRisk.LOW) {
                return CodemodFileScanningResult.none();
            }
            if (fix.getFix() == null || fix.getFix().isEmpty()) {
                logger.info("unable to fix: {}", (Object)context.path());
                return CodemodFileScanningResult.none();
            }
            List<String> fixedLines = LLMDiffs.applyDiff(file.getLines(), fix.getFix());
            Patch patch = DiffUtils.diff(file.getLines(), fixedLines);
            if (patch.getDeltas().isEmpty() || !this.isPatchExpected((Patch<String>)patch)) {
                logger.error("unexpected patch: {}", (Object)patch);
                return CodemodFileScanningResult.none();
            }
            try {
                String fixedFile = String.join((CharSequence)file.getLineSeparator(), fixedLines);
                Files.writeString(context.path(), (CharSequence)fixedFile, file.getCharset(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            int line = ((AbstractDelta)patch.getDeltas().get(0)).getSource().getPosition() + 1;
            List<CodemodChange> changes = List.of(CodemodChange.from((int)line, (String)fix.getFixDescription()));
            return CodemodFileScanningResult.withOnlyChanges(changes);
        }
        catch (IOException e) {
            logger.error("failed to process: {}", (Object)context.path(), (Object)e);
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            logger.error("failed to process: {}", (Object)context.path(), (Object)e);
            throw e;
        }
    }

    protected abstract String getThreatPrompt(CodemodInvocationContext var1, List<Result> var2);

    protected abstract String getFixPrompt();

    protected abstract boolean isPatchExpected(Patch<String> var1);

    private BinaryThreatAnalysis analyzeThreat(FileDescription file, CodemodInvocationContext context, List<Result> results) throws IOException {
        ChatRequestSystemMessage systemMessage = this.getSystemMessage(context, results);
        ChatRequestUserMessage userMessage = this.getAnalyzeUserMessage(file);
        int tokenCount = this.model.tokens(List.of(systemMessage.getContent(), userMessage.getContent().toString()));
        if (tokenCount > this.model.contextWindow() - 300) {
            return new BinaryThreatAnalysis("Ignoring file: estimated prompt token count (" + tokenCount + ") is too high.", BinaryThreatRisk.LOW);
        }
        logger.debug("estimated prompt token count: {}", (Object)tokenCount);
        return this.openAI.getResponseForPrompt(List.of(systemMessage, userMessage), this.model, BinaryThreatAnalysis.class);
    }

    private BinaryThreatAnalysisAndFix fixThreat(FileDescription file, CodemodInvocationContext context, List<Result> results) throws IOException {
        return this.openAI.getResponseForPrompt(List.of(this.getSystemMessage(context, results), this.getFixUserMessage(file)), this.model, BinaryThreatAnalysisAndFix.class);
    }

    private ChatRequestSystemMessage getSystemMessage(CodemodInvocationContext context, List<Result> results) {
        String threatPrompt = this.getThreatPrompt(context, results);
        return new ChatRequestSystemMessage(SYSTEM_MESSAGE_TEMPLATE.formatted(threatPrompt.strip()).strip());
    }

    private ChatRequestUserMessage getAnalyzeUserMessage(FileDescription file) {
        return new ChatRequestUserMessage(ANALYZE_USER_MESSAGE_TEMPLATE.formatted(file.getFileName(), file.formatLinesWithLineNumbers()).strip());
    }

    private ChatRequestUserMessage getFixUserMessage(FileDescription file) {
        return new ChatRequestUserMessage(FIX_USER_MESSAGE_TEMPLATE.formatted(this.getFixPrompt().strip(), file.getFileName(), file.formatLinesWithLineNumbers()).strip());
    }
}

