/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.llm;

import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRequestSystemMessage;
import com.azure.ai.openai.models.ChatRequestUserMessage;
import com.contrastsecurity.sarif.Location;
import com.contrastsecurity.sarif.Region;
import com.contrastsecurity.sarif.Result;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.github.difflib.DiffUtils;
import com.github.difflib.patch.Patch;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.CodemodInvocationContext;
import io.codemodder.RuleSarif;
import io.codemodder.plugins.llm.FileDescription;
import io.codemodder.plugins.llm.LLMDiffs;
import io.codemodder.plugins.llm.LLMRemediationOutcome;
import io.codemodder.plugins.llm.Model;
import io.codemodder.plugins.llm.OpenAIService;
import io.codemodder.plugins.llm.SarifPluginLLMCodemod;
import io.codemodder.plugins.llm.StandardModel;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SarifToLLMForMultiOutcomeCodemod
extends SarifPluginLLMCodemod {
    private static final Logger logger = LoggerFactory.getLogger(SarifToLLMForMultiOutcomeCodemod.class);
    private final List<LLMRemediationOutcome> remediationOutcomes;
    private final Model categorizationModel;
    private final Model codeChangingModel;
    private static final String SYSTEM_MESSAGE_TEMPLATE = "You are a security analyst bot. You are helping analyze code to assess its risk to a specific security threat. Your code change recommendations are safe and accurate.\n%s\n";
    private static final String CATEGORIZE_CODE_USER_MESSAGE_TEMPLATE = "Analyze ONLY line %s, column %s, and discern which \"outcome\" best describes the code. You should save your categorization analysis. You MUST ignore any other file contents, even if they look like they have issues.\nHere are the possible outcomes:\n%s\n\nReturn a JSON object as a response with the following keys in this order:\n  - analysis: A detailed analysis of how the analysis arrived at the outcome\n  - outcomeKey: The category of the analysis, or empty if the analysis could not be categorized\n--- %s\n%s\n";
    private static final String CHANGE_CODE_USER_MESSAGE_TEMPLATE = "The tool has cited the following location for you to analyze:\n%s\nDecide which \"outcome\" you want to place it in. Then, if that outcome requires code changes, make the changes as described in the Code Change Directions and save them. Here are the possible outcomes:\n%s\nPick which outcome best describes the code. If you are making code changes, you MUST make the MINIMUM number of changes necessary to fix the issue.\n- Each change MUST be syntactically correct.\n- DO NOT change the file's formatting or comments.\n- Create a diff patch for the changed file if and only if any of the outcomes require code changes.\n- The patch must use the unified format with a header. Include the diff patch and a summary of the changes with your analysis.\nIf you the outcome says you should suppress a Semgrep finding in the code, insert a comment above it and put `// nosemgrep: <ruleid>`\nSave your categorization and code change analysis when you're done.\n\nReturn a JSON object as a response with the following keys in this order:\n  - outcomeKey: The outcome key associated with this particular result location\n  - fixDescription: A short description of the code change. Required only if the file needs a change.\n  - codeChange: A diff patch in unified format. Required if any of the outcome keys indicate a change.\n  - line: The line in the file to which this analysis is related\n  - column: The column to which this analysis is related\n--- %s\n%s\n";

    protected SarifToLLMForMultiOutcomeCodemod(RuleSarif sarif, OpenAIService openAI, List<LLMRemediationOutcome> remediationOutcomes) {
        this(sarif, openAI, remediationOutcomes, StandardModel.GPT_4O_2024_05_13, StandardModel.GPT_4_TURBO_2024_04_09);
    }

    protected SarifToLLMForMultiOutcomeCodemod(RuleSarif sarif, OpenAIService openAI, List<LLMRemediationOutcome> remediationOutcomes, Model categorizationModel, Model codeChangingModel) {
        super(sarif, openAI);
        this.remediationOutcomes = Objects.requireNonNull(remediationOutcomes);
        if (remediationOutcomes.size() < 2) {
            throw new IllegalArgumentException("must have 2+ remediation outcome");
        }
        this.categorizationModel = Objects.requireNonNull(categorizationModel);
        this.codeChangingModel = Objects.requireNonNull(codeChangingModel);
    }

    public CodemodFileScanningResult onFileFound(CodemodInvocationContext context, List<Result> results) {
        logger.debug("processing: {}", (Object)context.path());
        ArrayList changes = new ArrayList();
        for (Result result : results) {
            Optional<CodemodChange> change = this.processResult(context, result);
            change.ifPresent(changes::add);
        }
        return CodemodFileScanningResult.withOnlyChanges(List.copyOf(changes));
    }

    private Optional<CodemodChange> processResult(CodemodInvocationContext context, Result result) {
        if (this.estimatedToExceedContextWindow(context)) {
            logger.debug("code too long: {}", (Object)context.path());
            return Optional.empty();
        }
        try {
            FileDescription file = FileDescription.from(context.path());
            CategorizeResponse analysis = this.categorize(file, result);
            String outcomeKey = analysis.getOutcomeKey();
            logger.debug("outcomeKey: {}", (Object)outcomeKey);
            logger.debug("analysis: {}", (Object)analysis.getAnalysis());
            if (outcomeKey == null || outcomeKey.isBlank()) {
                logger.debug("unable to determine outcome");
                return Optional.empty();
            }
            Optional<LLMRemediationOutcome> outcome = this.remediationOutcomes.stream().filter(oc -> oc.key().equals(analysis.outcomeKey)).findFirst();
            if (outcome.isEmpty()) {
                logger.debug("unable to find outcome for key: {}", (Object)analysis.outcomeKey);
                return Optional.empty();
            }
            LLMRemediationOutcome matchedOutcome = outcome.get();
            logger.debug("outcomeKey: {}", (Object)matchedOutcome.key());
            logger.debug("description: {}", (Object)matchedOutcome.description());
            if (!matchedOutcome.shouldApplyCodeChanges()) {
                logger.debug("Matched outcome suggests there should be no code changes");
                return Optional.empty();
            }
            CodeChangeResponse response = this.changeCode(file, result);
            logger.debug("outcome: {}", (Object)response.outcomeKey);
            logger.debug("analysis: {}", (Object)response.codeChange);
            if (response.outcomeKey == null || outcomeKey.isEmpty()) {
                logger.debug("No outcomes detected");
                return Optional.empty();
            }
            List<String> codeChangingOutcomeKeys = this.remediationOutcomes.stream().filter(LLMRemediationOutcome::shouldApplyCodeChanges).map(LLMRemediationOutcome::key).toList();
            boolean anyRequireCodeChanges = codeChangingOutcomeKeys.contains(response.outcomeKey);
            if (!anyRequireCodeChanges) {
                logger.debug("On second analysis, outcomes require no code changes");
                return Optional.empty();
            }
            String codeChange = response.codeChange;
            if (codeChange == null || codeChange.isEmpty()) {
                logger.info("unable to fix because diff not present: {}", (Object)context.path());
                return Optional.empty();
            }
            List<String> fixedLines = LLMDiffs.applyDiff(file.getLines(), codeChange);
            Patch patch = DiffUtils.diff(file.getLines(), fixedLines);
            if (patch.getDeltas().isEmpty()) {
                logger.error("empty patch: {}", (Object)patch);
                return Optional.empty();
            }
            try {
                String fixedFile = String.join((CharSequence)file.getLineSeparator(), fixedLines);
                Files.writeString(context.path(), (CharSequence)fixedFile, file.getCharset(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return Optional.of(this.createCodemodChange(result, response.line, response.fixDescription));
        }
        catch (IOException e) {
            logger.error("failed to process: {}", (Object)context.path(), (Object)e);
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            logger.error("failed to process: {}", (Object)context.path(), (Object)e);
            throw e;
        }
    }

    private boolean estimatedToExceedContextWindow(CodemodInvocationContext context) {
        ChatRequestUserMessage estimatedUserMessage = new ChatRequestUserMessage(context.contents());
        for (Model model : List.of(this.categorizationModel, this.codeChangingModel)) {
            int tokenCount = model.tokens(List.of(this.getSystemMessage().getContent(), estimatedUserMessage.getContent().toString()));
            if ((tokenCount += 300) <= model.contextWindow()) continue;
            return true;
        }
        return false;
    }

    protected CodemodChange createCodemodChange(Result result, int line, String fixDescription) {
        return CodemodChange.from((int)line, (String)fixDescription);
    }

    protected abstract String getThreatPrompt();

    private CategorizeResponse categorize(FileDescription file, Result result) throws IOException {
        ChatRequestSystemMessage systemMessage = this.getSystemMessage();
        ChatRequestMessage userMessage = this.getCategorizationUserMessage(file, result);
        return this.getCategorizationResponse((ChatRequestMessage)systemMessage, userMessage);
    }

    private CodeChangeResponse changeCode(FileDescription file, Result result) throws IOException {
        return this.getCodeChangeResponse((ChatRequestMessage)this.getSystemMessage(), this.getChangeCodeMessage(file, result));
    }

    private CategorizeResponse getCategorizationResponse(ChatRequestMessage systemMessage, ChatRequestMessage userMessage) throws IOException {
        return this.openAI.getResponseForPrompt(List.of(systemMessage, userMessage), this.categorizationModel, CategorizeResponse.class);
    }

    private CodeChangeResponse getCodeChangeResponse(ChatRequestMessage systemMessage, ChatRequestMessage userMessage) throws IOException {
        return this.openAI.getResponseForPrompt(List.of(systemMessage, userMessage), this.codeChangingModel, CodeChangeResponse.class);
    }

    private ChatRequestSystemMessage getSystemMessage() {
        return new ChatRequestSystemMessage(SYSTEM_MESSAGE_TEMPLATE.formatted(this.getThreatPrompt().strip()).strip());
    }

    private ChatRequestMessage getCategorizationUserMessage(FileDescription file, Result result) {
        Region region = ((Location)result.getLocations().get(0)).getPhysicalLocation().getRegion();
        int line = region.getStartLine();
        Integer column = region.getStartColumn();
        String outcomeDescriptions = this.formatOutcomeDescriptions(false);
        return new ChatRequestSystemMessage(CATEGORIZE_CODE_USER_MESSAGE_TEMPLATE.formatted(String.valueOf(line), column != null ? String.valueOf(column) : "(unknown)", outcomeDescriptions, file.getFileName(), file.formatLinesWithLineNumbers()).strip());
    }

    private String formatOutcomeDescriptions(boolean includeFixes) {
        String withFixTemplate = "============\nOutcome: %s\nDescription: %s\nCode Changes Required: YES\nCode Change Directions For Outcome: %s\n";
        String withoutFixTemplate = "============\nOutcome: %s\nDescription: %s\nCode Changes Required: NO\n";
        Function<LLMRemediationOutcome, String> withFixProvider = outcome -> withFixTemplate.formatted(outcome.key(), outcome.description(), outcome.fix());
        Function<LLMRemediationOutcome, String> withoutFixProvider = outcome -> withoutFixTemplate.formatted(outcome.key(), outcome.description());
        return this.remediationOutcomes.stream().map(oc -> includeFixes ? (String)withFixProvider.apply((LLMRemediationOutcome)oc) : (String)withoutFixProvider.apply((LLMRemediationOutcome)oc)).collect(Collectors.joining("\n")) + "\n============";
    }

    private ChatRequestMessage getChangeCodeMessage(FileDescription file, Result result) {
        Region region = ((Location)result.getLocations().get(0)).getPhysicalLocation().getRegion();
        String regionStr = "  Line " + region.getStartLine() + ", column " + region.getStartColumn();
        String outcomeDescriptions = this.formatOutcomeDescriptions(true);
        return new ChatRequestUserMessage(CHANGE_CODE_USER_MESSAGE_TEMPLATE.formatted(regionStr, outcomeDescriptions, file.getFileName(), file.formatLinesWithLineNumbers()).strip());
    }

    static class CategorizeResponse {
        @JsonPropertyDescription(value="A detailed analysis of how the analysis arrived at the outcome")
        @JsonProperty(required=true)
        private String analysis;
        @JsonPropertyDescription(value="The category of the analysis, or empty if the analysis could not categorized")
        @JsonProperty(required=true)
        private String outcomeKey;

        public CategorizeResponse() {
        }

        private CategorizeResponse(String analysis, String outcomeKey) {
            this.analysis = analysis;
            this.outcomeKey = outcomeKey;
        }

        public String getAnalysis() {
            return this.analysis;
        }

        public String getOutcomeKey() {
            return this.outcomeKey;
        }
    }

    static final class CodeChangeResponse {
        @JsonPropertyDescription(value="The code change a diff patch in unified format. Required if any of the outcome keys indicate a change.")
        private String codeChange;
        @JsonPropertyDescription(value="The line in the file to which this analysis is related")
        private int line;
        @JsonPropertyDescription(value="The column to which this analysis is related")
        private int column;
        @JsonPropertyDescription(value="The outcome key associated with this particular result location")
        private String outcomeKey;
        @JsonPropertyDescription(value="A short description of the code change. Required only if the file needs a change.")
        private String fixDescription;

        CodeChangeResponse() {
        }

        public String getFixDescription() {
            return this.fixDescription;
        }

        public String getOutcomeKey() {
            return this.outcomeKey;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public String getCodeChange() {
            return this.codeChange;
        }
    }
}

