/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.llm;

import com.knuddels.jtokkit.api.EncodingType;
import io.codemodder.plugins.llm.Model;
import io.codemodder.plugins.llm.Tokens;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum StandardModel implements Model
{
    GPT_3_5_TURBO_0125("gpt-3.5-turbo-0125", 16385){

        @Override
        public int tokens(List<String> messages) {
            return Tokens.countTokens(messages, 3, EncodingType.CL100K_BASE);
        }
    }
    ,
    GPT_4_0613("gpt-4-0613", 8192){

        @Override
        public int tokens(List<String> messages) {
            return Tokens.countTokens(messages, 3, EncodingType.CL100K_BASE);
        }
    }
    ,
    GPT_4_TURBO_2024_04_09("gpt-4-turbo-2024-04-09", 128000){

        @Override
        public int tokens(List<String> messages) {
            return Tokens.countTokens(messages, 3, EncodingType.CL100K_BASE);
        }
    }
    ,
    GPT_4O_2024_05_13("gpt-4o-2024-05-13", 128000){

        @Override
        public int tokens(List<String> messages) {
            return Tokens.countTokens(messages, 3, EncodingType.CL100K_BASE);
        }
    };

    private final String id;
    private final int contextWindow;

    private StandardModel(String id, int contextWindow) {
        this.id = id;
        this.contextWindow = contextWindow;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public int contextWindow() {
        return this.contextWindow;
    }
}

