/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.llm;

import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import com.github.difflib.patch.PatchFailedException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LLMDiffs {
    private static final Pattern HUNK_RANGE_PATTERN = Pattern.compile("^@@\\s+-(\\d+)(?:,\\d+)?\\s+\\+\\d+(?:,\\d+)?\\s+@@");
    private static final int MAX_FUZZ = 3;

    private LLMDiffs() {
    }

    public static List<String> applyDiff(List<String> target, String diff) {
        try {
            List<String> fixedDiff = LLMDiffs.fixDiffWhitespace(target, List.of(diff.strip().split("\n")));
            Patch patch = UnifiedDiffUtils.parseUnifiedDiff(fixedDiff);
            return patch.applyFuzzy(target, 3);
        }
        catch (PatchFailedException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static List<String> fixDiffWhitespace(List<String> target, List<String> diff) {
        ArrayList<String> fixedDiff = new ArrayList<String>();
        boolean inHeader = true;
        ArrayList<String> hunk = new ArrayList<String>();
        int start = 0;
        for (String line : diff) {
            if (inHeader) {
                fixedDiff.add(line);
                if (!line.startsWith("+++")) continue;
                inHeader = false;
                continue;
            }
            Matcher m = HUNK_RANGE_PATTERN.matcher(line);
            if (m.find()) {
                if (!hunk.isEmpty()) {
                    fixedDiff.addAll(LLMDiffs.fixHunkWhitespace(target, hunk, start));
                    hunk.clear();
                }
                fixedDiff.add(m.group(0));
                start = Integer.parseInt(m.group(1));
                continue;
            }
            hunk.add(!line.isEmpty() ? line : " ");
        }
        fixedDiff.addAll(LLMDiffs.fixHunkWhitespace(target, hunk, start));
        return List.copyOf(fixedDiff);
    }

    private static List<String> fixHunkWhitespace(List<String> target, List<String> hunk, int start) {
        int i;
        int index = -1;
        int n = i = start > 3 ? start - 3 - 1 : 0;
        while (i < start + 3 && i < target.size()) {
            if (LLMDiffs.isStart(target, hunk, i)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return hunk;
        }
        ArrayList<Object> fixedHunk = new ArrayList<Object>(hunk.size());
        for (String line : hunk) {
            if (line.startsWith("+")) {
                fixedHunk.add(line);
                continue;
            }
            fixedHunk.add(line.charAt(0) + target.get(index++));
        }
        return List.copyOf(fixedHunk);
    }

    private static boolean isStart(List<String> target, List<String> hunk, int index) {
        int adds = 0;
        for (int i = 0; i < hunk.size(); ++i) {
            if (hunk.get(i).startsWith("+")) {
                ++adds;
                continue;
            }
            int targetIndex = index + i - adds;
            if (targetIndex >= target.size()) {
                return false;
            }
            if (hunk.get(i).substring(1).strip().equals(target.get(targetIndex).strip())) continue;
            return false;
        }
        return true;
    }
}

