/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.llm;

import com.google.inject.AbstractModule;
import io.codemodder.plugins.llm.OpenAIService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LLMServiceModule
extends AbstractModule {
    private static final String OPENAI_KEY_NAME = "CODEMODDER_OPENAI_API_KEY";
    private static final String AZURE_OPENAI_KEY_NAME = "CODEMODDER_AZURE_OPENAI_API_KEY";
    private static final String AZURE_OPENAI_ENDPOINT = "CODEMODDER_AZURE_OPENAI_ENDPOINT";
    private static final Logger logger = LoggerFactory.getLogger(LLMServiceModule.class);

    protected void configure() {
        String azureOpenAIKey = System.getenv(AZURE_OPENAI_KEY_NAME);
        String azureOpenAIEndpoint = System.getenv(AZURE_OPENAI_ENDPOINT);
        if (azureOpenAIEndpoint == null != (azureOpenAIKey == null)) {
            throw new IllegalArgumentException("Both or neither of CODEMODDER_AZURE_OPENAI_API_KEY and CODEMODDER_AZURE_OPENAI_ENDPOINT must be set");
        }
        if (azureOpenAIKey != null) {
            logger.info("Using Azure OpenAI service with endpoint {}", (Object)azureOpenAIEndpoint);
            this.bind(OpenAIService.class).toProvider(() -> OpenAIService.fromAzureOpenAI(azureOpenAIKey, azureOpenAIEndpoint));
            return;
        }
        String openAIKey = System.getenv(OPENAI_KEY_NAME);
        if (openAIKey != null) {
            logger.info("Using OpenAI service");
            this.bind(OpenAIService.class).toProvider(() -> OpenAIService.fromOpenAI(openAIKey));
            return;
        }
        logger.info("No LLM service available");
        this.bind(OpenAIService.class).toProvider(OpenAIService::noServiceAvailable);
    }
}

