/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven;

import io.codemodder.DependencyDescriptor;
import io.codemodder.DependencyGAV;
import io.codemodder.DependencyUpdateResult;
import io.codemodder.ProjectProvider;
import io.codemodder.plugins.maven.ArtifactInjectionPositionFinder;
import io.codemodder.plugins.maven.CodeTFGenerator;
import io.codemodder.plugins.maven.DefaultArtifactInjectionPositionFinder;
import io.codemodder.plugins.maven.DefaultPOMDependencyUpdater;
import io.codemodder.plugins.maven.POMDependencyUpdater;
import io.codemodder.plugins.maven.PomFileFinder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MavenProvider
implements ProjectProvider {
    private final POMDependencyUpdater pomDependencyUpdater;
    private static final Logger LOG = LoggerFactory.getLogger(MavenProvider.class);

    MavenProvider(PomModifier pomModifier, PomFileFinder pomFileFinder, DependencyDescriptor dependencyDescriptor, ArtifactInjectionPositionFinder positionFinder) {
        Objects.requireNonNull(pomModifier);
        Objects.requireNonNull(pomFileFinder);
        this.pomDependencyUpdater = new DefaultPOMDependencyUpdater(new CodeTFGenerator(positionFinder, dependencyDescriptor), pomFileFinder, pomModifier);
    }

    MavenProvider(PomModifier pomModifier, PomFileFinder pomFileFinder, DependencyDescriptor dependencyDescriptor) {
        this(pomModifier, pomFileFinder, dependencyDescriptor, new DefaultArtifactInjectionPositionFinder());
    }

    MavenProvider(PomModifier pomModifier) {
        this(pomModifier, new DefaultPomFileFinder(), DependencyDescriptor.createMarkdownDescriptor(), new DefaultArtifactInjectionPositionFinder());
    }

    public MavenProvider() {
        this(new DefaultPomModifier(), new DefaultPomFileFinder(), DependencyDescriptor.createMarkdownDescriptor(), new DefaultArtifactInjectionPositionFinder());
    }

    public DependencyUpdateResult updateDependencies(Path projectDir, Path file, List<DependencyGAV> dependencies) {
        try {
            String dependenciesStr = dependencies.stream().map(Object::toString).collect(Collectors.joining(","));
            LOG.trace("Updating dependencies for {} in {}: {}", new Object[]{file, projectDir, dependenciesStr});
            DependencyUpdateResult dependencyUpdateResult = this.pomDependencyUpdater.execute(projectDir, file, dependencies);
            LOG.trace("Dependency update result: {}", (Object)dependencyUpdateResult);
            return dependencyUpdateResult;
        }
        catch (Exception e) {
            throw new DependencyUpdateException("Failure when updating dependencies", e);
        }
    }

    static interface PomModifier {
        public void modify(Path var1, byte[] var2) throws IOException;
    }

    @VisibleForTesting
    static class DefaultPomFileFinder
    implements PomFileFinder {
        DefaultPomFileFinder() {
        }

        @Override
        public Optional<Path> findForFile(Path projectDir, Path file) throws IOException {
            for (Path parent = file.getParent(); parent != null && !Files.isSameFile(projectDir.getParent(), parent); parent = parent.getParent()) {
                Path pomPath = parent.resolve("pom.xml");
                if (!Files.exists(pomPath, new LinkOption[0])) continue;
                return Optional.of(pomPath);
            }
            return Optional.empty();
        }
    }

    static class DefaultPomModifier
    implements PomModifier {
        DefaultPomModifier() {
        }

        @Override
        public void modify(Path path, byte[] contents) throws IOException {
            Files.write(path, contents, new OpenOption[0]);
        }
    }

    static class DependencyUpdateException
    extends RuntimeException {
        DependencyUpdateException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

