/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven.operator;

import io.codemodder.plugins.maven.operator.AbstractCommand;
import io.codemodder.plugins.maven.operator.Dependency;
import io.codemodder.plugins.maven.operator.InvalidContextException;
import io.codemodder.plugins.maven.operator.POMDocument;
import io.codemodder.plugins.maven.operator.ProjectModel;
import io.github.pixee.security.BoundedLineReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractQueryCommand
extends AbstractCommand {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractQueryCommand.class);
    protected Collection<Dependency> result = null;

    AbstractQueryCommand() {
    }

    private Path getOutputPath(Path pomFilePath) {
        Path basePath = pomFilePath.getParent();
        String outputBasename = String.format("output-%08X.txt", pomFilePath.hashCode());
        return basePath.resolve(outputBasename);
    }

    private Path getPomFilePath(POMDocument d) throws URISyntaxException {
        return Paths.get(d.getPomPath().toURI());
    }

    protected abstract void extractDependencyTree(Path var1, Path var2, ProjectModel var3);

    public Collection<Dependency> getResult() {
        return this.result;
    }

    @Override
    public boolean execute(ProjectModel pm) throws URISyntaxException, IOException {
        Path pomFilePath = this.getPomFilePath(pm.getPomFile());
        Path outputPath = this.getOutputPath(pomFilePath);
        if (Files.exists(outputPath, new LinkOption[0])) {
            Files.delete(outputPath);
        }
        try {
            this.extractDependencyTree(outputPath, pomFilePath, pm);
        }
        catch (InvalidContextException e) {
            return false;
        }
        this.result = this.extractDependencies(outputPath).values();
        return true;
    }

    private Map<String, Dependency> extractDependencies(Path outputPath) throws IOException {
        HashMap<String, Dependency> dependencyMap = new HashMap<String, Dependency>();
        try (BufferedReader reader = Files.newBufferedReader(outputPath);){
            String line;
            boolean skipFirstLine = true;
            while ((line = BoundedLineReader.readLine((Reader)reader, (int)5000000)) != null) {
                if (skipFirstLine) {
                    skipFirstLine = false;
                    continue;
                }
                String trimmedLine = this.trimSpecialChars(line);
                String[] elements = trimmedLine.split(":");
                if (elements.length < 5) continue;
                String groupId = elements[0];
                String artifactId = elements[1];
                String packaging = elements[2];
                String version = elements[3];
                String scope = elements[4];
                Dependency dependency = new Dependency(groupId, artifactId, version, null, packaging, scope);
                dependencyMap.put(line, dependency);
            }
        }
        return dependencyMap;
    }

    private String trimSpecialChars(String input) {
        int start;
        char[] specialChars = "+-|\\ ".toCharArray();
        int end = input.length();
        for (start = 0; start < end && this.isSpecialChar(input.charAt(start)); ++start) {
        }
        while (end > start && this.isSpecialChar(input.charAt(end - 1))) {
            --end;
        }
        if (start > 0 || end < input.length()) {
            return input.substring(start, end);
        }
        return input;
    }

    private boolean isSpecialChar(char c) {
        char[] specialChars;
        for (char specialChar : specialChars = "+-|\\ ".toCharArray()) {
            if (c != specialChar) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean postProcess(ProjectModel c) {
        return false;
    }
}

