/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven.operator;

import io.codemodder.plugins.maven.operator.AbstractCommand;
import io.codemodder.plugins.maven.operator.POMDocument;
import io.codemodder.plugins.maven.operator.ProjectModel;
import io.codemodder.plugins.maven.operator.Util;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

class CompositeDependencyManagement
extends AbstractCommand {
    CompositeDependencyManagement() {
    }

    @Override
    public boolean execute(ProjectModel pm) {
        if (pm.getParentPomFiles().isEmpty()) {
            return false;
        }
        boolean result = false;
        POMDocument parentPomFile = pm.getParentPomFiles().get(pm.getParentPomFiles().size() - 1);
        Element dependencyManagementElement = parentPomFile.getResultPom().getRootElement().elements("dependencyManagement").isEmpty() ? Util.addIndentedElement(parentPomFile.getResultPom().getRootElement(), parentPomFile, "dependencyManagement") : parentPomFile.getResultPom().getRootElement().element("dependencyManagement");
        Element newDependencyManagementElement = this.modifyDependency(parentPomFile, Util.buildLookupExpressionForDependencyManagement(pm.getDependency()), pm, dependencyManagementElement, true);
        if (pm.isUseProperties()) {
            if (newDependencyManagementElement != null) {
                Element newVersionNode = Util.addIndentedElement(newDependencyManagementElement, parentPomFile, "version");
                Util.upgradeVersionNode(pm, newVersionNode, parentPomFile);
            } else {
                throw new IllegalStateException("newDependencyManagementElement is missing");
            }
        }
        this.modifyDependency(pm.getPomFile(), Util.buildLookupExpressionForDependency(pm.getDependency()), pm, pm.getPomFile().getResultPom().getRootElement(), false);
        if (!result) {
            result = pm.getPomFile().getDirty();
        }
        return result;
    }

    private Element modifyDependency(POMDocument pomFileToModify, String lookupExpressionForDependency, ProjectModel c, Element parentElement, boolean dependencyManagementNode) {
        List<Node> dependencyNodes = Util.selectXPathNodes((Node)pomFileToModify.getResultPom(), lookupExpressionForDependency);
        if (dependencyNodes.size() == 1) {
            List<Node> versionNodes = Util.selectXPathNodes(dependencyNodes.get(0), "./m:version");
            if (versionNodes.size() == 1) {
                Element versionNode = (Element)versionNodes.get(0);
                versionNode.getParent().content().remove(versionNode);
                pomFileToModify.setDirty(true);
            }
            return (Element)dependencyNodes.get(0);
        }
        Element dependenciesNode = parentElement.element("dependencies") != null ? parentElement.element("dependencies") : Util.addIndentedElement(parentElement, pomFileToModify, "dependencies");
        Element dependencyNode = Util.addIndentedElement(dependenciesNode, pomFileToModify, "dependency");
        Util.addIndentedElement(dependencyNode, pomFileToModify, "groupId").setText(c.getDependency().getGroupId());
        Util.addIndentedElement(dependencyNode, pomFileToModify, "artifactId").setText(c.getDependency().getArtifactId());
        if (dependencyManagementNode && !c.isUseProperties()) {
            Util.addIndentedElement(dependencyNode, pomFileToModify, "version").setText(c.getDependency().getVersion());
        }
        pomFileToModify.setDirty(true);
        return dependencyNode;
    }
}

