/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven.operator;

import io.codemodder.plugins.maven.operator.AbstractCommand;
import io.codemodder.plugins.maven.operator.POMDocument;
import io.codemodder.plugins.maven.operator.ProjectModel;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Diff;

class DiscardFormatCommand
extends AbstractCommand {
    DiscardFormatCommand() {
    }

    @Override
    public boolean postProcess(ProjectModel pm) throws XMLStreamException {
        boolean mustSkip = false;
        for (POMDocument pomFile : pm.allPomFiles()) {
            Source originalDoc = Input.fromString((String)new String(pomFile.getOriginalPom())).build();
            Source modifiedDoc = Input.fromString((String)pomFile.getResultPom().asXML()).build();
            Diff diff = DiffBuilder.compare((Object)originalDoc).withTest((Object)modifiedDoc).ignoreWhitespace().ignoreComments().ignoreElementContentWhitespace().checkForSimilar().build();
            boolean hasDifferences = diff.hasDifferences();
            if (pm.isModifiedByCommand() || hasDifferences) continue;
            pomFile.setResultPomBytes(pomFile.getOriginalPom());
            mustSkip = true;
        }
        if (mustSkip) {
            return true;
        }
        return super.postProcess(pm);
    }
}

