/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven.operator;

import io.codemodder.plugins.maven.operator.Dependency;
import io.codemodder.plugins.maven.operator.POMDocument;
import io.codemodder.plugins.maven.operator.Pair;
import io.codemodder.plugins.maven.operator.QueryType;
import io.codemodder.plugins.maven.operator.Util;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.dom4j.Node;

public class ProjectModel {
    private POMDocument pomFile;
    private List<POMDocument> parentPomFiles;
    private Dependency dependency;
    private boolean skipIfNewer;
    private boolean useProperties;
    private Set<String> activeProfiles;
    private boolean overrideIfAlreadyExists;
    private QueryType queryType;
    private Path repositoryPath;
    private String finishedByClass;
    private boolean modifiedByCommand;

    public ProjectModel(POMDocument pomFile, List<POMDocument> parentPomFiles, Dependency dependency, boolean skipIfNewer, boolean useProperties, Set<String> activeProfiles, boolean overrideIfAlreadyExists, QueryType queryType, Path repositoryPath, String finishedByClass) {
        this.pomFile = pomFile;
        this.parentPomFiles = parentPomFiles != null ? parentPomFiles : Collections.emptyList();
        this.dependency = dependency;
        this.skipIfNewer = skipIfNewer;
        this.useProperties = useProperties;
        this.activeProfiles = activeProfiles;
        this.overrideIfAlreadyExists = overrideIfAlreadyExists;
        this.queryType = queryType != null ? queryType : QueryType.NONE;
        this.repositoryPath = repositoryPath;
        this.finishedByClass = finishedByClass;
        this.modifiedByCommand = false;
    }

    public static Map<String, String> propertiesDefinedOnPomDocument(POMDocument pomFile) {
        HashMap<String, String> rootProperties = new HashMap<String, String>();
        List propertyElements = pomFile.getPomDocument().getRootElement().elements("properties");
        for (Element element : propertyElements) {
            List elements = element.elements();
            for (Element propertyElement : elements) {
                rootProperties.put(propertyElement.getName(), propertyElement.getText());
            }
        }
        return rootProperties;
    }

    private Map<String, String> getPropertiesFromProfile(String profileName, POMDocument pomFile) {
        String expression = "/m:project/m:profiles/m:profile[./m:id[text()='" + profileName + "']]/m:properties";
        List<Node> propertiesElements = Util.selectXPathNodes((Node)pomFile.getPomDocument(), expression);
        HashMap<String, String> newPropertiesToAppend = new HashMap<String, String>();
        for (Node element : propertiesElements) {
            if (!(element instanceof Element)) continue;
            List elements = ((Element)element).elements();
            for (Element propertyElement : elements) {
                newPropertiesToAppend.put(propertyElement.getName(), propertyElement.getText());
            }
        }
        return newPropertiesToAppend;
    }

    public Map<String, List<Pair<String, POMDocument>>> propertiesDefinedByFile() {
        LinkedHashMap<String, List<Pair<String, POMDocument>>> result = new LinkedHashMap<String, List<Pair<String, POMDocument>>>();
        List<POMDocument> allPomFiles = this.allPomFiles();
        for (POMDocument pomFile : allPomFiles) {
            Map<String, String> rootProperties = ProjectModel.propertiesDefinedOnPomDocument(pomFile);
            LinkedHashMap<String, String> tempProperties = new LinkedHashMap<String, String>(rootProperties);
            ArrayList<String> activatedProfiles = new ArrayList<String>();
            for (String profile : this.activeProfiles) {
                if (profile.startsWith("!")) continue;
                activatedProfiles.add(profile);
            }
            ArrayList<Map<String, String>> newPropertiesFromProfiles = new ArrayList<Map<String, String>>();
            for (String string : activatedProfiles) {
                newPropertiesFromProfiles.add(this.getPropertiesFromProfile(string, pomFile));
            }
            for (Map map : newPropertiesFromProfiles) {
                tempProperties.putAll(map);
            }
            for (Map.Entry entry : tempProperties.entrySet()) {
                String key = (String)entry.getKey();
                if (!result.containsKey(key)) {
                    result.put(key, new ArrayList());
                }
                List definitionList = (List)result.get(key);
                definitionList.add(new Pair<String, POMDocument>((String)entry.getValue(), pomFile));
            }
        }
        return result;
    }

    public Map<String, String> resolvedProperties() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        List<POMDocument> allPomFiles = this.allPomFiles();
        Collections.reverse(allPomFiles);
        for (POMDocument pomFile : allPomFiles) {
            Map<String, String> rootProperties = ProjectModel.propertiesDefinedOnPomDocument(pomFile);
            result.putAll(rootProperties);
            ArrayList<String> activatedProfiles = new ArrayList<String>();
            for (String profile : this.activeProfiles) {
                if (profile.startsWith("!")) continue;
                activatedProfiles.add(profile);
            }
            ArrayList<Map<String, String>> newPropertiesFromProfiles = new ArrayList<Map<String, String>>();
            for (String string : activatedProfiles) {
                newPropertiesFromProfiles.add(this.getPropertiesFromProfile(string, pomFile));
            }
            for (Map map : newPropertiesFromProfiles) {
                result.putAll(map);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    public List<POMDocument> allPomFiles() {
        ArrayList<POMDocument> allFiles = new ArrayList<POMDocument>();
        allFiles.add(this.pomFile);
        allFiles.addAll(this.parentPomFiles);
        return allFiles;
    }

    public POMDocument getPomFile() {
        return this.pomFile;
    }

    public void setPomFile(POMDocument pomFile) {
        this.pomFile = pomFile;
    }

    public List<POMDocument> getParentPomFiles() {
        return this.parentPomFiles;
    }

    public void setParentPomFiles(List<POMDocument> parentPomFiles) {
        this.parentPomFiles = parentPomFiles;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public void setDependency(Dependency dependency) {
        this.dependency = dependency;
    }

    public boolean isSkipIfNewer() {
        return this.skipIfNewer;
    }

    public void setSkipIfNewer(boolean skipIfNewer) {
        this.skipIfNewer = skipIfNewer;
    }

    public boolean isUseProperties() {
        return this.useProperties;
    }

    public void setUseProperties(boolean useProperties) {
        this.useProperties = useProperties;
    }

    public Set<String> getActiveProfiles() {
        return this.activeProfiles;
    }

    public void setActiveProfiles(Set<String> activeProfiles) {
        this.activeProfiles = activeProfiles;
    }

    public boolean isOverrideIfAlreadyExists() {
        return this.overrideIfAlreadyExists;
    }

    public void setOverrideIfAlreadyExists(boolean overrideIfAlreadyExists) {
        this.overrideIfAlreadyExists = overrideIfAlreadyExists;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType;
    }

    public Path getRepositoryPath() {
        return this.repositoryPath;
    }

    public void setRepositoryPath(Path repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    public String getFinishedByClass() {
        return this.finishedByClass;
    }

    public void setFinishedByClass(String finishedByClass) {
        this.finishedByClass = finishedByClass;
    }

    public boolean isModifiedByCommand() {
        return this.modifiedByCommand;
    }

    public void setModifiedByCommand(boolean modifiedByCommand) {
        this.modifiedByCommand = modifiedByCommand;
    }
}

