/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven.operator;

import io.codemodder.plugins.maven.operator.AbstractQueryCommand;
import io.codemodder.plugins.maven.operator.Dependency;
import io.codemodder.plugins.maven.operator.POMDocument;
import io.codemodder.plugins.maven.operator.ProjectModel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryByParsing
extends AbstractQueryCommand {
    private final Set<Dependency> dependencies = new LinkedHashSet<Dependency>();
    private final Set<Dependency> dependencyManagement = new TreeSet<Dependency>(new Comparator<Dependency>(){

        @Override
        public int compare(Dependency o1, Dependency o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return new CompareToBuilder().append((Object)o1.getGroupId(), (Object)o2.getGroupId()).append((Object)o1.getArtifactId(), (Object)o2.getArtifactId()).toComparison();
        }
    });
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private final StrSubstitutor strSubstitutor = new StrSubstitutor(this.properties);
    private static final Pattern RE_INTERPOLATION = Pattern.compile(".*\\$\\{[\\p{Alnum}.\\-_]+\\}.*");
    private static final Logger logger = LoggerFactory.getLogger(QueryByParsing.class);

    QueryByParsing() {
    }

    @Override
    public void extractDependencyTree(Path outputPath, Path pomFilePath, ProjectModel c) {
    }

    @Override
    public boolean execute(ProjectModel pm) {
        List<POMDocument> pomFilesByHierarchy = pm.allPomFiles();
        Collections.reverse(pomFilesByHierarchy);
        for (POMDocument pomDocument : pomFilesByHierarchy) {
            this.updateProperties(pomDocument);
            this.updateDependencyManagement(pomDocument);
            this.updateDependencies(pomDocument);
        }
        this.result = this.dependencies;
        return true;
    }

    private void updateDependencyManagement(POMDocument pomDocument) {
        ArrayList<Dependency> dependencyManagementDependenciesToAdd = new ArrayList<Dependency>();
        Element dependencyManagementElement = pomDocument.getPomDocument().getRootElement().element("dependencyManagement");
        if (dependencyManagementElement != null) {
            List dependencyElements = dependencyManagementElement.element("dependencies").elements("dependency");
            for (Element dependencyElement : dependencyElements) {
                String groupId = this.getElementTextOrNull(dependencyElement, "groupId");
                String artifactId = this.getElementTextOrNull(dependencyElement, "artifactId");
                String version = Optional.ofNullable(dependencyElement.elementText("version")).orElse("UNKNOWN");
                String classifier = this.getElementTextOrNull(dependencyElement, "classifier");
                String packaging = this.getElementTextOrNull(dependencyElement, "packaging");
                try {
                    version = this.strSubstitutor.replace(version);
                }
                catch (IllegalStateException e) {
                    logger.warn("while interpolating version", (Throwable)e);
                    version = "UNKNOWN";
                }
                Dependency dependency = new Dependency(groupId, artifactId, version, classifier, packaging, null);
                dependencyManagementDependenciesToAdd.add(dependency);
            }
        }
        this.dependencyManagement.addAll(dependencyManagementDependenciesToAdd);
    }

    private Dependency lookForDependencyManagement(String groupId, String artifactId) {
        for (Dependency dependency : this.dependencyManagement) {
            if (!Objects.equals(dependency.getGroupId(), groupId) || !Objects.equals(dependency.getArtifactId(), artifactId)) continue;
            return dependency;
        }
        return null;
    }

    private void updateDependencies(POMDocument pomDocument) {
        ArrayList<Dependency> dependenciesToAdd = new ArrayList<Dependency>();
        Element dependenciesElement = pomDocument.getPomDocument().getRootElement().element("dependencies");
        if (dependenciesElement != null) {
            List dependencyElements = dependenciesElement.elements("dependency");
            for (Element dependencyElement : dependencyElements) {
                String groupId = this.getElementTextOrNull(dependencyElement, "groupId");
                String artifactId = this.getElementTextOrNull(dependencyElement, "artifactId");
                String version = Optional.ofNullable(dependencyElement.elementText("version")).orElse("UNKNOWN");
                Dependency proposedDependency = this.lookForDependencyManagement(groupId, artifactId);
                if (proposedDependency != null) {
                    dependenciesToAdd.add(proposedDependency);
                    continue;
                }
                String classifier = this.getElementTextOrNull(dependencyElement, "classifier");
                String packaging = this.getElementTextOrNull(dependencyElement, "packaging");
                try {
                    version = this.strSubstitutor.replace(version);
                }
                catch (IllegalStateException e) {
                    logger.warn("while interpolating version", (Throwable)e);
                    version = "UNKNOWN";
                }
                Dependency dependency = new Dependency(groupId, artifactId, version, classifier, packaging, null);
                dependenciesToAdd.add(dependency);
            }
        }
        this.dependencies.addAll(dependenciesToAdd);
    }

    private String getElementTextOrNull(Element parent, String elementName) {
        Element child = parent.element(elementName);
        return child != null ? child.getText() : null;
    }

    private void updateProperties(POMDocument pomDocument) {
        Map<String, String> propsDefined = ProjectModel.propertiesDefinedOnPomDocument(pomDocument);
        for (Map.Entry<String, String> entry : propsDefined.entrySet()) {
            String newValue;
            String key = entry.getKey();
            String value = entry.getValue();
            if (!value.matches(RE_INTERPOLATION.pattern())) {
                this.properties.put(key, value);
            }
            if (value.matches(RE_INTERPOLATION.pattern())) continue;
            try {
                Matcher matcher = RE_INTERPOLATION.matcher(value);
                StringBuffer resultBuffer = new StringBuffer();
                while (matcher.find()) {
                    String variable = matcher.group();
                    String replacement = this.strSubstitutor.replace(variable);
                    matcher.appendReplacement(resultBuffer, Matcher.quoteReplacement(replacement));
                }
                matcher.appendTail(resultBuffer);
                newValue = resultBuffer.toString();
            }
            catch (IllegalStateException e) {
                LOGGER.warn("while replacing variables: ", (Throwable)e);
                newValue = value;
            }
            this.properties.put(key, newValue);
        }
    }
}

