/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven.operator;

import io.codemodder.plugins.maven.operator.Command;
import io.codemodder.plugins.maven.operator.Dependency;
import io.codemodder.plugins.maven.operator.ProjectModel;
import io.codemodder.plugins.maven.operator.Util;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

class SimpleInsert
implements Command {
    private final boolean validateDependencyExistence;

    SimpleInsert(boolean validateDependencyExistence) {
        this.validateDependencyExistence = validateDependencyExistence;
    }

    @Override
    public boolean execute(ProjectModel pm) {
        Element rootDependencyNode;
        Element dependenciesNode;
        if (this.validateDependencyExistence && this.checkDependencyExists(pm)) {
            return true;
        }
        List<Node> dependencyManagementNodeList = Util.selectXPathNodes((Node)pm.getPomFile().getResultPom(), "/m:project/m:dependencyManagement");
        if (dependencyManagementNodeList.isEmpty()) {
            Element newDependencyManagementNode = Util.addIndentedElement(pm.getPomFile().getResultPom().getRootElement(), pm.getPomFile(), "dependencyManagement");
            dependenciesNode = Util.addIndentedElement(newDependencyManagementNode, pm.getPomFile(), "dependencies");
        } else {
            dependenciesNode = ((Element)dependencyManagementNodeList.get(0)).element("dependencies");
        }
        Element dependencyNode = this.appendCoordinates(dependenciesNode, pm);
        Element versionNode = Util.addIndentedElement(dependencyNode, pm.getPomFile(), "version");
        Util.upgradeVersionNode(pm, versionNode, pm.getPomFile());
        List<Node> dependenciesNodeList = Util.selectXPathNodes((Node)pm.getPomFile().getResultPom(), "//m:project/m:dependencies");
        if (dependenciesNodeList.isEmpty()) {
            rootDependencyNode = Util.addIndentedElement(pm.getPomFile().getResultPom().getRootElement(), pm.getPomFile(), "dependencies");
        } else if (dependenciesNodeList.size() == 1) {
            rootDependencyNode = (Element)dependenciesNodeList.get(0);
        } else {
            throw new IllegalStateException("More than one dependencies node");
        }
        this.appendCoordinates(rootDependencyNode, pm);
        return true;
    }

    private boolean checkDependencyExists(ProjectModel pm) {
        String lookupExpressionForDependency = Util.buildLookupExpressionForDependency(pm.getDependency());
        List<Node> matchedDependencies = Util.selectXPathNodes((Node)pm.getPomFile().getResultPom(), lookupExpressionForDependency);
        return !matchedDependencies.isEmpty();
    }

    private Element appendCoordinates(Element dependenciesNode, ProjectModel c) {
        Element dependencyNode = Util.addIndentedElement(dependenciesNode, c.getPomFile(), "dependency");
        Element groupIdNode = Util.addIndentedElement(dependencyNode, c.getPomFile(), "groupId");
        Dependency dep = c.getDependency();
        if (dep != null) {
            groupIdNode.setText(dep.getGroupId());
        }
        Element artifactIdNode = Util.addIndentedElement(dependencyNode, c.getPomFile(), "artifactId");
        if (dep != null) {
            artifactIdNode.setText(dep.getArtifactId());
        }
        return dependencyNode;
    }

    @Override
    public boolean postProcess(ProjectModel c) {
        return false;
    }
}

