/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven;

import com.github.difflib.patch.AbstractDelta;
import io.codemodder.plugins.maven.ArtifactInjectionPositionFinder;
import java.util.List;

final class DefaultArtifactInjectionPositionFinder
implements ArtifactInjectionPositionFinder {
    DefaultArtifactInjectionPositionFinder() {
    }

    @Override
    public int find(List<AbstractDelta<String>> deltas, String artifactId) {
        String expectedArtifactToken = "<artifactId>" + artifactId + "</artifactId>";
        Integer backupPosition = null;
        for (AbstractDelta<String> delta : deltas) {
            List newLines = delta.getTarget().getLines();
            boolean hasArtifactId = newLines.stream().anyMatch(line -> line.contains(expectedArtifactToken));
            boolean hasVersion = newLines.stream().anyMatch(line -> line.contains("<version>"));
            if (hasArtifactId && hasVersion) {
                backupPosition = 1 + delta.getSource().getPosition();
                continue;
            }
            if (!hasArtifactId) continue;
            return 1 + delta.getSource().getPosition();
        }
        if (backupPosition != null) {
            return backupPosition;
        }
        return 1 + deltas.get(0).getSource().getPosition();
    }
}

