/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven.operator;

import io.codemodder.plugins.maven.operator.Command;
import io.codemodder.plugins.maven.operator.ProjectModel;
import io.codemodder.plugins.maven.operator.Util;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.dom4j.Element;
import org.dom4j.Node;

abstract class AbstractCommand
implements Command {
    AbstractCommand() {
    }

    protected boolean handleDependency(ProjectModel pm, String lookupExpression) {
        List<Node> versionNodes;
        List<Node> dependencyNodes = Util.selectXPathNodes((Node)pm.getPomFile().getResultPom(), lookupExpression);
        if (1 == dependencyNodes.size() && 1 == (versionNodes = Util.selectXPathNodes(dependencyNodes.get(0), "./m:version")).size()) {
            Element versionNode = (Element)versionNodes.get(0);
            boolean mustUpgrade = true;
            if (pm.isSkipIfNewer()) {
                mustUpgrade = Util.findOutIfUpgradeIsNeeded(pm, versionNode);
            }
            if (mustUpgrade) {
                Util.upgradeVersionNode(pm, versionNode, pm.getPomFile());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean execute(ProjectModel pm) throws URISyntaxException, IOException, XMLStreamException {
        return false;
    }

    @Override
    public boolean postProcess(ProjectModel c) throws XMLStreamException {
        return false;
    }

    protected Path getLocalRepositoryPath(ProjectModel pm) {
        Path localRepositoryPath = null;
        localRepositoryPath = pm.getRepositoryPath() != null ? pm.getRepositoryPath() : (System.getenv("M2_REPO") != null ? Paths.get(System.getenv("M2_REPO"), new String[0]) : (System.getProperty("maven.repo.local") != null ? Paths.get(System.getProperty("maven.repo.local"), new String[0]) : Paths.get(System.getProperty("user.home"), ".m2/repository")));
        return localRepositoryPath;
    }
}

