/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven.operator;

import io.codemodder.plugins.maven.operator.AbstractCommand;
import io.codemodder.plugins.maven.operator.POMDocument;
import io.codemodder.plugins.maven.operator.ProjectModel;
import io.codemodder.plugins.maven.operator.Util;
import io.codemodder.plugins.maven.operator.WrongDependencyTypeException;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;

class CheckParentPackaging
extends AbstractCommand {
    private static final CheckParentPackaging INSTANCE = new CheckParentPackaging();

    private CheckParentPackaging() {
    }

    public static CheckParentPackaging getInstance() {
        return INSTANCE;
    }

    private boolean packagingTypePredicate(POMDocument d, String packagingType) {
        Node elementText;
        List<Node> elementTextList = Util.selectXPathNodes((Node)d.getPomDocument().getRootElement(), "/m:project/m:packaging/text()");
        Node node = elementText = elementTextList.isEmpty() ? null : elementTextList.get(0);
        if (elementText instanceof Text) {
            return ((Text)elementText).getText().equals(packagingType);
        }
        return false;
    }

    @Override
    public boolean execute(ProjectModel pm) {
        List<POMDocument> wrongParentPoms = pm.getParentPomFiles().stream().filter(pomFile -> !this.packagingTypePredicate((POMDocument)pomFile, "pom")).toList();
        if (!wrongParentPoms.isEmpty()) {
            throw new WrongDependencyTypeException("Wrong packaging type for parentPom");
        }
        if (!pm.getParentPomFiles().isEmpty() && !this.hasValidParentAndPackaging(pm.getPomFile())) {
            throw new WrongDependencyTypeException("Invalid parent/packaging combo for main pomfile");
        }
        return false;
    }

    private boolean hasValidParentAndPackaging(POMDocument pomFile) {
        Element parentNode;
        List<Node> parentNodes = Util.selectXPathNodes((Node)pomFile.getPomDocument().getRootElement(), "/m:project/m:parent");
        Element element = parentNode = parentNodes.isEmpty() ? null : (Element)parentNodes.get(0);
        if (parentNode == null) {
            return false;
        }
        List<Node> packagingNodes = Util.selectXPathNodes((Node)pomFile.getPomDocument().getRootElement(), "/m:project/m:packaging/text()");
        String packagingText = packagingNodes.isEmpty() ? "jar" : ((Text)packagingNodes.get(0)).getText();
        boolean validPackagingType = packagingText.endsWith("ar");
        return validPackagingType;
    }
}

