/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven.operator;

import io.codemodder.plugins.maven.operator.AbstractQueryCommand;
import io.codemodder.plugins.maven.operator.CheckDependencyPresent;
import io.codemodder.plugins.maven.operator.CheckLocalRepositoryDirCommand;
import io.codemodder.plugins.maven.operator.CheckParentPackaging;
import io.codemodder.plugins.maven.operator.Command;
import io.codemodder.plugins.maven.operator.CompositeDependencyManagement;
import io.codemodder.plugins.maven.operator.DiscardFormatCommand;
import io.codemodder.plugins.maven.operator.FormatCommand;
import io.codemodder.plugins.maven.operator.Pair;
import io.codemodder.plugins.maven.operator.ProjectModel;
import io.codemodder.plugins.maven.operator.QueryType;
import io.codemodder.plugins.maven.operator.SimpleDependencyManagement;
import io.codemodder.plugins.maven.operator.SimpleInsert;
import io.codemodder.plugins.maven.operator.SimpleUpgrade;
import io.codemodder.plugins.maven.operator.SupportCommand;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommandChain {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandChain.class);
    private List<Command> commandList;
    private static List<Command> COMMON_COMMANDS = List.of(CheckDependencyPresent.getInstance(), CheckParentPackaging.getInstance(), new FormatCommand(), new DiscardFormatCommand(), new CompositeDependencyManagement());
    static final List<Pair<QueryType, String>> AVAILABLE_DEPENDENCY_QUERY_COMMANDS = new ArrayList<Pair>(Arrays.asList(new Pair<QueryType, String>(QueryType.SAFE, "QueryByParsing")));
    private static final List<Pair<QueryType, String>> AVAILABLE_QUERY_VERSION_COMMANDS = new ArrayList<Pair>(Arrays.asList(new Pair<QueryType, String>(QueryType.SAFE, "VersionByCompilerDefinition"), new Pair<QueryType, String>(QueryType.SAFE, "VersionByProperty")));

    private CommandChain(List<Command> commands) {
        this.commandList = commands;
    }

    public List<Command> getCommandList() {
        return this.commandList;
    }

    public boolean execute(ProjectModel c) throws URISyntaxException, IOException, XMLStreamException {
        Command nextCommand;
        boolean done = false;
        ListIterator<Command> listIterator = this.commandList.listIterator();
        while (!done && listIterator.hasNext()) {
            Command nextCommand2 = listIterator.next();
            done = nextCommand2.execute(c);
            if (!done) continue;
            if (c.getQueryType() == QueryType.NONE && !(nextCommand2 instanceof SupportCommand)) {
                c.setModifiedByCommand(true);
            }
            c.setFinishedByClass(nextCommand2.getClass().getName());
            break;
        }
        boolean result = done;
        while (listIterator.previousIndex() > 0 && !(done = (nextCommand = listIterator.previous()).postProcess(c))) {
        }
        return result;
    }

    public static CommandChain modifyDependency() {
        ArrayList<Command> modifyCommands = new ArrayList<Command>(COMMON_COMMANDS);
        modifyCommands.addAll(List.of(SimpleUpgrade.getInstance(), SimpleDependencyManagement.getInstance(), new SimpleInsert(false)));
        return new CommandChain(modifyCommands);
    }

    public static CommandChain insertDependency() {
        ArrayList<Command> insertCommands = new ArrayList<Command>(COMMON_COMMANDS);
        insertCommands.add(new SimpleInsert(true));
        return new CommandChain(insertCommands);
    }

    public static CommandChain updateDependency() {
        ArrayList<Command> insertCommands = new ArrayList<Command>(COMMON_COMMANDS);
        insertCommands.addAll(List.of(SimpleUpgrade.getInstance(), SimpleDependencyManagement.getInstance()));
        return new CommandChain(insertCommands);
    }

    private static CommandChain filterByQueryType(List<Pair<QueryType, String>> commandList, QueryType queryType, List<AbstractQueryCommand> initialCommands, QueryTypeFilter queryTypeFilter) {
        ArrayList<Command> filteredCommands = new ArrayList<Command>();
        for (Pair<QueryType, String> pair : commandList) {
            if (!queryTypeFilter.filter(pair.getFirst())) continue;
            String commandClassName = "io.codemodder.plugins.maven.operator." + pair.getSecond();
            try {
                Class<?> commandClass = Class.forName(commandClassName);
                Command command = (Command)commandClass.newInstance();
                filteredCommands.add(command);
            }
            catch (Exception e) {
                LOGGER.warn("Creating class '{}': ", (Object)commandClassName, (Object)e);
            }
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.addAll(initialCommands);
        commands.addAll(filteredCommands);
        if (commands.isEmpty()) {
            throw new IllegalStateException("Unable to load any available strategy for " + queryType.name());
        }
        return new CommandChain(commands);
    }

    public static CommandChain createForDependencyQuery(QueryType queryType) {
        return CommandChain.filterByQueryType(AVAILABLE_DEPENDENCY_QUERY_COMMANDS, queryType, Arrays.asList(CheckLocalRepositoryDirCommand.CheckParentDirCommand.getInstance()), it -> it == queryType);
    }

    public static CommandChain createForVersionQuery(QueryType queryType) {
        return CommandChain.filterByQueryType(AVAILABLE_QUERY_VERSION_COMMANDS, queryType, Collections.emptyList(), it -> it.ordinal() <= queryType.ordinal());
    }

    private static interface QueryTypeFilter {
        public boolean filter(QueryType var1);
    }
}

