/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven.operator;

import io.codemodder.DependencyGAV;
import java.util.Objects;

class Dependency {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String packaging;
    private String scope;

    Dependency(String groupId, String artifactId, String version, String classifier, String packaging, String scope) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.packaging = packaging != null ? packaging : "jar";
        this.scope = scope != null ? scope : "compile";
    }

    Dependency(DependencyGAV newDependencyGAV) {
        this(newDependencyGAV.group(), newDependencyGAV.artifact(), newDependencyGAV.version(), null, null, null);
    }

    public String toString() {
        return String.join((CharSequence)":", this.groupId, this.artifactId, this.packaging, this.version);
    }

    static Dependency fromString(String str) {
        String[] elements = str.split(":");
        if (elements.length < 3) {
            throw new IllegalStateException("Give me at least 3 elements");
        }
        return new Dependency(elements[0], elements[1], elements[2], null, null, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependency that = (Dependency)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version) && Objects.equals(this.classifier, that.classifier) && Objects.equals(this.packaging, that.packaging) && Objects.equals(this.scope, that.scope);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version, this.classifier, this.packaging, this.scope);
    }

    public int hashWithoutVersion() {
        return Objects.hash(this.groupId, this.artifactId, this.classifier, this.packaging, this.scope);
    }

    public boolean matchesWithoutConsideringVersion(Dependency dependency) {
        return this.hashWithoutVersion() == dependency.hashWithoutVersion();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

