/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven.operator;

import io.codemodder.plugins.maven.operator.AbstractCommand;
import io.codemodder.plugins.maven.operator.MatchData;
import io.codemodder.plugins.maven.operator.POMDocument;
import io.codemodder.plugins.maven.operator.Pair;
import io.codemodder.plugins.maven.operator.ProjectModel;
import io.github.pixee.security.XMLInputFactorySecurity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.universalchardet.UniversalDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FormatCommand
extends AbstractCommand {
    private static final Set<String> LINE_ENDINGS = new HashSet<String>();
    private static final Regex RE_EMPTY_ELEMENT_NO_ATTRIBUTES;
    private static final Logger LOGGER;
    private XMLInputFactory inputFactory = XMLInputFactorySecurity.hardenFactory((XMLInputFactory)XMLInputFactory.newInstance());
    private XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    private List<MatchData> singleElementsWithAttributes = new ArrayList<MatchData>();

    FormatCommand() {
    }

    @Override
    public boolean execute(ProjectModel pm) throws XMLStreamException, IOException, URISyntaxException {
        for (POMDocument pomFile : pm.allPomFiles()) {
            this.parseXmlAndCharset(pomFile);
            pomFile.setEndl(this.parseLineEndings(pomFile));
            pomFile.setIndent(this.guessIndent(pomFile));
        }
        return super.execute(pm);
    }

    @Override
    public boolean postProcess(ProjectModel pm) throws XMLStreamException {
        for (POMDocument pomFile : pm.allPomFiles()) {
            byte[] content = this.serializePomFile(pomFile);
            pomFile.setResultPomBytes(content);
        }
        return super.postProcess(pm);
    }

    private BitSet elementBitSet(byte[] doc) throws XMLStreamException {
        BitSet result = new BitSet();
        XMLEventReader eventReader = this.inputFactory.createXMLEventReader(new ByteArrayInputStream(doc));
        StringWriter eventContent = new StringWriter();
        XMLEventWriter xmlEventWriter = this.outputFactory.createXMLEventWriter(eventContent);
        while (eventReader.hasNext()) {
            XMLEvent next = eventReader.nextEvent();
            if (!(next instanceof StartElement) && !(next instanceof EndElement)) continue;
            int startIndex = next.getLocation().getCharacterOffset();
            eventContent.getBuffer().setLength(0);
            xmlEventWriter.add(next);
            xmlEventWriter.flush();
            int endIndex = startIndex + eventContent.getBuffer().length();
            result.set(startIndex, startIndex + endIndex);
        }
        return result;
    }

    private String writeAsRegex(StartElement element) {
        StringWriter writer = new StringWriter();
        writer.write("<");
        writer.write(Pattern.quote(element.getName().getLocalPart()));
        Iterator<Attribute> attrIter = element.getAttributes();
        while (attrIter.hasNext()) {
            Attribute attr = attrIter.next();
            writer.write("\\s+");
            writer.write(Pattern.quote(attr.getName().getLocalPart()));
            writer.write("=[\\\"']");
            writer.write(Pattern.quote(attr.getValue()));
            writer.write("[\\\"']");
        }
        writer.write("\\s*\\/>");
        return writer.toString();
    }

    private String parseLineEndings(POMDocument pomFile) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pomFile.getOriginalPom());
        byte[] bytes = ((InputStream)inputStream).readAllBytes();
        String str = new String(bytes, pomFile.getCharset());
        HashMap<String, Integer> lineEndingCounts = new HashMap<String, Integer>();
        for (String lineEnding : LINE_ENDINGS) {
            lineEndingCounts.put(lineEnding, str.split(lineEnding).length);
        }
        return (String)Collections.max(lineEndingCounts.entrySet(), Map.Entry.comparingByValue()).getKey();
    }

    private String guessIndent(POMDocument pomFile) throws XMLStreamException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pomFile.getOriginalPom());
        XMLEventReader eventReader = this.inputFactory.createXMLEventReader(inputStream);
        HashMap<Integer, Integer> freqMap = new HashMap<Integer, Integer>();
        HashMap<Character, Integer> charFreqMap = new HashMap<Character, Integer>();
        while (eventReader.hasNext()) {
            String[] patterns;
            Characters characters;
            String data;
            XMLEvent event = eventReader.nextEvent();
            if (!(event instanceof Characters) || !StringUtils.isWhitespace((CharSequence)(data = (characters = (Characters)event).getData()))) continue;
            String lineEndingsPattern = String.join((CharSequence)"|", LINE_ENDINGS.toArray(new String[0]));
            for (String pattern : patterns = data.split(lineEndingsPattern)) {
                if (pattern.isEmpty() || !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{pattern})) continue;
                int length = pattern.length();
                freqMap.merge(length, 1, Integer::sum);
                char firstChar = pattern.charAt(0);
                charFreqMap.merge(Character.valueOf(firstChar), 1, Integer::sum);
            }
        }
        char indentCharacter = this.getMostFrequentIndentChar(charFreqMap);
        String indentCharacterAsString = String.valueOf(indentCharacter);
        int indentLength = this.getMinimumIndentLength(freqMap);
        String indentString = StringUtils.repeat((String)indentCharacterAsString, (int)indentLength);
        return indentString;
    }

    private char getMostFrequentIndentChar(Map<Character, Integer> charFreqMap) {
        char mostFrequentChar = '\u0000';
        int maxFrequency = Integer.MIN_VALUE;
        for (Map.Entry<Character, Integer> entry : charFreqMap.entrySet()) {
            if (entry.getValue() <= maxFrequency) continue;
            maxFrequency = entry.getValue();
            mostFrequentChar = entry.getKey().charValue();
        }
        return mostFrequentChar;
    }

    private int getMinimumIndentLength(Map<Integer, Integer> freqMap) {
        int minIndentLength = Integer.MAX_VALUE;
        for (Map.Entry<Integer, Integer> entry : freqMap.entrySet()) {
            if (entry.getKey() >= minIndentLength) continue;
            minIndentLength = entry.getKey();
        }
        return minIndentLength;
    }

    private void parseXmlAndCharset(POMDocument pomFile) throws XMLStreamException, IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pomFile.getOriginalPom());
        XMLEventReader eventReader = this.inputFactory.createXMLEventReader(inputStream);
        Charset charset = null;
        int elementIndex = 0;
        boolean mustTrack = false;
        boolean hasPreamble = false;
        int elementStart = 0;
        boolean elementEnd = false;
        ArrayList<XMLEvent> prevEvents = new ArrayList<XMLEvent>();
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartDocument() && ((StartDocument)event).encodingSet()) {
                charset = Charset.forName(((StartDocument)event).getCharacterEncodingScheme());
            } else if (event.isStartElement()) {
                StartElement asStartElement = event.asStartElement();
                String name = asStartElement.getName().getLocalPart();
                ArrayList<Attribute> attributes = new ArrayList<Attribute>();
                Iterator<Attribute> attrIter = asStartElement.getAttributes();
                while (attrIter.hasNext()) {
                    attributes.add(attrIter.next());
                }
                if (elementIndex > 0 && !attributes.isEmpty()) {
                    mustTrack = true;
                    XMLEvent lastCharacterEvent = null;
                    for (int i = prevEvents.size() - 1; i >= 0; --i) {
                        if (!((XMLEvent)prevEvents.get(i)).isCharacters()) continue;
                        lastCharacterEvent = ((XMLEvent)prevEvents.get(i)).asCharacters();
                        break;
                    }
                    if (lastCharacterEvent != null) {
                        elementStart = lastCharacterEvent.getLocation().getCharacterOffset() - lastCharacterEvent.getData().length();
                    }
                } else if (mustTrack) {
                    mustTrack = false;
                }
                ++elementIndex;
            } else if (event.isEndElement()) {
                EndElement endElementEvent = event.asEndElement();
                Location location = endElementEvent.getLocation();
                int offset = location.getCharacterOffset();
                if (mustTrack) {
                    mustTrack = false;
                    String localPart = event.asEndElement().getName().getLocalPart();
                    String originalPomCharsetString = new String(pomFile.getOriginalPom(), pomFile.getCharset());
                    String untrimmedOriginalContent = originalPomCharsetString.substring(elementStart, offset);
                    String trimmedOriginalContent = untrimmedOriginalContent.trim();
                    int realElementStart = originalPomCharsetString.indexOf(trimmedOriginalContent, elementStart);
                    IntRange contentRange = new IntRange(realElementStart, realElementStart + 1 + trimmedOriginalContent.length());
                    String contentRe = this.writeAsRegex(this.getLastStartElement(prevEvents));
                    Regex modifiedContentRE = new Regex(contentRe);
                    this.singleElementsWithAttributes.add(new MatchData(contentRange, trimmedOriginalContent, localPart, true, modifiedContentRE));
                }
                mustTrack = false;
                if (!hasPreamble) {
                    pomFile.setPreamble(new String(pomFile.getOriginalPom(), pomFile.getCharset()).substring(0, offset));
                    hasPreamble = true;
                }
            }
            prevEvents.add(event);
            while (prevEvents.size() > 4) {
                prevEvents.remove(0);
            }
            if (eventReader.hasNext() || hasPreamble) continue;
            throw new IllegalStateException("Couldn't find document start");
        }
        if (null == charset) {
            ByteArrayInputStream inputStream2 = new ByteArrayInputStream(pomFile.getOriginalPom());
            String detectedCharsetName = UniversalDetector.detectCharset((InputStream)inputStream2);
            charset = Charset.forName(detectedCharsetName);
        }
        pomFile.setCharset(charset);
        String lastLine = new String(pomFile.getOriginalPom(), pomFile.getCharset());
        String lastLineTrimmed = lastLine.replaceAll("\\s+$", "");
        pomFile.setSuffix(lastLine.substring(lastLineTrimmed.length()));
    }

    private StartElement getLastStartElement(List<XMLEvent> prevEvents) {
        for (int i = prevEvents.size() - 1; i >= 0; --i) {
            XMLEvent event = prevEvents.get(i);
            if (!event.isStartElement()) continue;
            return (StartElement)event;
        }
        return null;
    }

    private LinkedHashMap<Integer, MatchData> findSingleElementMatchesFrom(String xmlDocumentString) {
        Sequence allFoundMatchesSequence = RE_EMPTY_ELEMENT_NO_ATTRIBUTES.findAll((CharSequence)xmlDocumentString, 0);
        ArrayList<MatchData> emptyMappedTags = new ArrayList<MatchData>();
        for (MatchResult matchResult : allFoundMatchesSequence) {
            MatchGroupCollection groups = matchResult.getGroups();
            String value1 = groups.get(1) != null ? groups.get(1).getValue() : null;
            String value2 = groups.get(2) != null ? groups.get(2).getValue() : null;
            MatchData matchDataJ = new MatchData(matchResult.getRange(), matchResult.getValue(), value1 != null ? value1 : value2, false, null);
            emptyMappedTags.add(matchDataJ);
        }
        List allTags = emptyMappedTags.stream().flatMap(data -> Stream.of(data)).map(data -> new Pair<Integer, MatchData>(data.getRange().getFirst(), (MatchData)data)).collect(Collectors.toList());
        allTags.sort(Comparator.comparing(Pair::getFirst, Comparator.reverseOrder()));
        LinkedHashMap<Integer, MatchData> linkedHashMap = new LinkedHashMap<Integer, MatchData>();
        for (Pair pair : allTags) {
            linkedHashMap.put((Integer)pair.getFirst(), (MatchData)pair.getSecond());
        }
        return linkedHashMap;
    }

    private List<MatchData> getElementsToReplace(BitSet originalElementMap, POMDocument pom) {
        ArrayList<MatchData> elementsToReplace = new ArrayList<MatchData>();
        LinkedHashMap<Integer, MatchData> singleElementMatches = this.findSingleElementMatchesFrom(new String(pom.getOriginalPom(), pom.getCharset()));
        for (MatchData match : singleElementMatches.values()) {
            if (match.getHasAttributes() || !originalElementMap.get(match.getRange().getFirst())) continue;
            elementsToReplace.add(match);
        }
        return elementsToReplace;
    }

    private Map<Integer, MatchData> getEmptyElements(BitSet targetElementMap, String xmlRepresentation) {
        LinkedHashMap<Integer, MatchData> emptyElements = new LinkedHashMap<Integer, MatchData>();
        for (Map.Entry<Integer, MatchData> entry : this.findSingleElementMatchesFrom(xmlRepresentation).entrySet()) {
            Integer key = entry.getKey();
            MatchData value = entry.getValue();
            if (!targetElementMap.get(value.getRange().getFirst())) continue;
            emptyElements.put(key, value);
        }
        return emptyElements;
    }

    private String replaceRange(String xmlRepresentation, IntRange range, String replacement) {
        StringBuilder sb = new StringBuilder();
        sb.append(xmlRepresentation.substring(0, range.getStart()));
        sb.append(replacement);
        sb.append(xmlRepresentation.substring(range.getEndInclusive() + 1, xmlRepresentation.length()));
        return sb.toString();
    }

    private byte[] serializePomFile(POMDocument pom) throws XMLStreamException {
        XMLEvent event;
        Object xmlRepresentation;
        block4: {
            xmlRepresentation = pom.getResultPom().asXML().toString();
            BitSet originalElementMap = this.elementBitSet(pom.getOriginalPom());
            BitSet targetElementMap = this.elementBitSet(((String)xmlRepresentation).getBytes());
            List<MatchData> elementsToReplace = this.getElementsToReplace(originalElementMap, pom);
            Map<Integer, MatchData> emptyElements = this.getEmptyElements(targetElementMap, (String)xmlRepresentation);
            for (Map.Entry<Integer, MatchData> entry : emptyElements.entrySet()) {
                Integer key = entry.getKey();
                MatchData match = entry.getValue();
                MatchData nextMatch = elementsToReplace.remove(0);
                xmlRepresentation = this.replaceRange((String)xmlRepresentation, match.getRange(), nextMatch.getContent());
            }
            int lastIndex = 0;
            this.singleElementsWithAttributes.sort(Comparator.comparingInt(matchDataJ -> matchDataJ.getRange().getFirst()));
            for (MatchData match : this.singleElementsWithAttributes) {
                MatchResult representationMatch = match.getModifiedContent().find((CharSequence)xmlRepresentation, lastIndex);
                if (null == representationMatch) {
                    LOGGER.warn("Failure on quoting: {}", (Object)match);
                    continue;
                }
                xmlRepresentation = this.replaceRange((String)xmlRepresentation, representationMatch.getRange(), match.getContent());
                lastIndex = representationMatch.getRange().getFirst() + match.getContent().length();
            }
            XMLInputFactory xMLInputFactory = XMLInputFactorySecurity.hardenFactory((XMLInputFactory)XMLInputFactory.newInstance());
            XMLEventReader eventReader = xMLInputFactory.createXMLEventReader(new ByteArrayInputStream(((String)xmlRepresentation).getBytes(pom.getCharset())));
            do {
                if ((event = eventReader.nextEvent()).isEndElement()) break block4;
            } while (eventReader.hasNext());
            throw new IllegalStateException("Couldn't find document start");
        }
        EndElement endElementEvent = (EndElement)event;
        int offset = endElementEvent.getLocation().getCharacterOffset();
        xmlRepresentation = pom.getPreamble() + ((String)xmlRepresentation).substring(offset) + pom.getSuffix();
        byte[] serializedContent = ((String)xmlRepresentation).getBytes(pom.getCharset());
        return serializedContent;
    }

    static {
        LOGGER = LoggerFactory.getLogger(FormatCommand.class);
        LINE_ENDINGS.add("\r\n");
        LINE_ENDINGS.add("\n");
        LINE_ENDINGS.add("\r");
        RE_EMPTY_ELEMENT_NO_ATTRIBUTES = new Regex("<([\\p{Alnum}_\\-.]+)>\\s*</\\1>|<([\\p{Alnum}_\\-.]+)\\s*/>");
    }
}

