/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven.operator;

import io.codemodder.plugins.maven.operator.POMDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

class POMDocumentFactory {
    private POMDocumentFactory() {
    }

    public static POMDocument load(InputStream is) throws IOException, DocumentException, URISyntaxException {
        byte[] originalPom = IOUtils.toByteArray((InputStream)is);
        SAXReader reader = new SAXReader();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(originalPom);
        Document pomDocument = reader.read((InputStream)inputStream);
        return new POMDocument(originalPom, null, pomDocument);
    }

    public static POMDocument load(Path filePath) throws IOException, DocumentException, URISyntaxException {
        URL fileUrl = filePath.toUri().toURL();
        return POMDocumentFactory.load(fileUrl);
    }

    public static POMDocument load(URL url) throws IOException, DocumentException, URISyntaxException {
        InputStream inputStream = url.openStream();
        byte[] originalPom = IOUtils.toByteArray((InputStream)inputStream);
        SAXReader saxReader = new SAXReader();
        Document pomDocument = saxReader.read((InputStream)new ByteArrayInputStream(originalPom));
        return new POMDocument(originalPom, url, pomDocument);
    }
}

