/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven.operator;

import io.codemodder.plugins.maven.operator.AbstractVersionCommand;
import io.codemodder.plugins.maven.operator.Kind;
import io.codemodder.plugins.maven.operator.POMDocument;
import io.codemodder.plugins.maven.operator.ProjectModel;
import io.codemodder.plugins.maven.operator.Util;
import io.codemodder.plugins.maven.operator.VersionDefinition;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.dom4j.Element;
import org.dom4j.Node;

class VersionByCompilerDefinition
extends AbstractVersionCommand {
    VersionByCompilerDefinition() {
    }

    @Override
    public boolean execute(ProjectModel pm) {
        TreeSet<VersionDefinition> definedSettings = new TreeSet<VersionDefinition>(AbstractVersionCommand.VERSION_KIND_COMPARATOR);
        List<String> parents = Arrays.asList("//m:project/m:build/m:pluginManagement/m:plugins", "//m:project/m:build/m:plugins");
        Map<String, String> properties = pm.resolvedProperties();
        StrSubstitutor sub = new StrSubstitutor(properties);
        for (String parent : parents) {
            for (POMDocument doc : pm.allPomFiles()) {
                String pluginExpression = parent + "/m:plugin[./m:artifactId[text()='maven-compiler-plugin']]//m:configuration";
                List<Node> compilerNodes = Util.selectXPathNodes((Node)doc.getResultPom(), pluginExpression);
                if (compilerNodes.isEmpty()) continue;
                for (Map.Entry<String, Kind> entry : AbstractVersionCommand.TYPE_TO_KIND.entrySet()) {
                    String key = entry.getKey();
                    Kind value = entry.getValue();
                    for (Node compilerNode : compilerNodes) {
                        Element childElement = ((Element)compilerNode).element(key);
                        if (childElement == null) continue;
                        String textTrim = childElement.getTextTrim();
                        String substitutedText = sub.replace(textTrim);
                        definedSettings.add(new VersionDefinition(value, substitutedText));
                    }
                }
            }
        }
        this.result.addAll(definedSettings);
        return !definedSettings.isEmpty();
    }
}

