/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import io.codemodder.DependencyDescriptor;
import io.codemodder.DependencyGAV;
import io.codemodder.codetf.CodeTFChange;
import io.codemodder.codetf.CodeTFChangesetEntry;
import io.codemodder.codetf.CodeTFDiffSide;
import io.codemodder.plugins.maven.ArtifactInjectionPositionFinder;
import io.codemodder.plugins.maven.MavenProvider;
import io.codemodder.plugins.maven.operator.POMDocument;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

final class CodeTFGenerator {
    private final ArtifactInjectionPositionFinder positionFinder;
    private final DependencyDescriptor dependencyDescriptor;

    CodeTFGenerator(ArtifactInjectionPositionFinder positionFinder, DependencyDescriptor dependencyDescriptor) {
        this.dependencyDescriptor = Objects.requireNonNull(dependencyDescriptor);
        this.positionFinder = Objects.requireNonNull(positionFinder);
    }

    CodeTFChangesetEntry getChanges(Path projectDir, POMDocument pomDocument, DependencyGAV newDependency) {
        List<String> originalPomContents = this.getLinesFrom(pomDocument, pomDocument.getOriginalPom());
        List<String> finalPomContents = this.getLinesFrom(pomDocument, pomDocument.getResultPomBytes());
        Patch patch = DiffUtils.diff(originalPomContents, finalPomContents);
        List deltas = patch.getDeltas();
        int position = this.positionFinder.find(deltas, newDependency.artifact());
        Path pomDocumentPath = this.getPomDocumentPath(pomDocument);
        String relativePomPath = projectDir.relativize(pomDocumentPath).toString();
        String description = this.dependencyDescriptor.create(newDependency);
        Map<String, String> properties = this.buildPropertiesMap(description);
        CodeTFChange change = new CodeTFChange(position, properties, description, CodeTFDiffSide.RIGHT, List.of(), List.of(), List.of());
        List patchDiff = UnifiedDiffUtils.generateUnifiedDiff((String)relativePomPath, (String)relativePomPath, originalPomContents, (Patch)patch, (int)3);
        String diff = String.join((CharSequence)pomDocument.getEndl(), patchDiff);
        return new CodeTFChangesetEntry(relativePomPath, diff, List.of(change));
    }

    private Path getPomDocumentPath(POMDocument pomDocument) {
        try {
            return new File(pomDocument.getPomPath().toURI()).toPath();
        }
        catch (URISyntaxException e) {
            throw new MavenProvider.DependencyUpdateException("Failure on URI for " + pomDocument.getPomPath(), e);
        }
    }

    private Map<String, String> buildPropertiesMap(String description) {
        return description != null && !description.isBlank() ? Map.of("contextual_description", "true") : Collections.emptyMap();
    }

    private List<String> getLinesFrom(POMDocument doc, byte[] byteArray) {
        return Arrays.asList(new String(byteArray, doc.getCharset()).split(Pattern.quote(doc.getEndl())));
    }
}

