/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven;

import io.codemodder.DependencyGAV;
import io.codemodder.DependencyUpdateResult;
import io.codemodder.codetf.CodeTFChangesetEntry;
import io.codemodder.plugins.maven.CodeTFGenerator;
import io.codemodder.plugins.maven.MavenProvider;
import io.codemodder.plugins.maven.POMDependencyUpdater;
import io.codemodder.plugins.maven.PomFileFinder;
import io.codemodder.plugins.maven.operator.POMDocument;
import io.codemodder.plugins.maven.operator.POMOperator;
import io.codemodder.plugins.maven.operator.ProjectModel;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.stream.XMLStreamException;
import org.dom4j.DocumentException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultPOMDependencyUpdater
implements POMDependencyUpdater {
    private final PomFileFinder pomFileFinder;
    private Optional<Path> maybePomFile;
    private final MavenProvider.PomModifier pomModifier;
    private final CodeTFGenerator codeTFGenerator;
    private List<CodeTFChangesetEntry> changesets;
    private List<DependencyGAV> skippedDependencies;
    private List<DependencyGAV> injectedDependencies;
    private Set<Path> erroredFiles;
    private AtomicReference<Collection<DependencyGAV>> foundDependenciesMapped;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPOMDependencyUpdater.class);

    DefaultPOMDependencyUpdater(CodeTFGenerator codeTFGenerator, PomFileFinder pomFileFinder, MavenProvider.PomModifier pomModifier) {
        this.pomFileFinder = Objects.requireNonNull(pomFileFinder);
        this.pomModifier = Objects.requireNonNull(pomModifier);
        this.codeTFGenerator = Objects.requireNonNull(codeTFGenerator);
    }

    @Override
    @NotNull
    public DependencyUpdateResult execute(Path projectDir, Path file, List<DependencyGAV> dependencies) {
        Collection<DependencyGAV> allFoundDependencies;
        try {
            if (this.isEmptyPomFile(projectDir, file)) {
                LOG.trace("Pom file was empty for {}", (Object)file);
                return DependencyUpdateResult.EMPTY_UPDATE;
            }
        }
        catch (IOException e) {
            LOG.warn("Not all Maven dependencies could be found", (Throwable)e);
            return DependencyUpdateResult.EMPTY_UPDATE;
        }
        Path pomFile = this.maybePomFile.get();
        POMOperator pomOperator = new POMOperator(pomFile, projectDir);
        this.changesets = new ArrayList<CodeTFChangesetEntry>();
        this.skippedDependencies = new ArrayList<DependencyGAV>();
        this.injectedDependencies = new ArrayList<DependencyGAV>();
        this.erroredFiles = new LinkedHashSet<Path>();
        try {
            allFoundDependencies = pomOperator.getAllFoundDependencies();
        }
        catch (IOException | URISyntaxException | XMLStreamException | DocumentException e) {
            LOG.warn("Problem calculating all dependencies", e);
            return DependencyUpdateResult.EMPTY_UPDATE;
        }
        this.foundDependenciesMapped = new AtomicReference<Collection<DependencyGAV>>(allFoundDependencies);
        LOG.trace("Beginning dependency set size: {}", (Object)this.foundDependenciesMapped.get().size());
        dependencies.forEach(newDependencyGAV -> {
            try {
                if (this.updateSkipDependencies((DependencyGAV)newDependencyGAV)) {
                    LOG.trace("Found it -- skipping");
                    return;
                }
                ProjectModel modifiedProjectModel = pomOperator.addDependency((DependencyGAV)newDependencyGAV);
                if (modifiedProjectModel == null) {
                    LOG.trace("POM file didn't need modification or it failed?");
                    return;
                }
                LOG.trace("Modified the pom -- writing it back");
                this.modifyPomFiles(projectDir, modifiedProjectModel, (DependencyGAV)newDependencyGAV);
                Collection<DependencyGAV> newDependencySet = pomOperator.getAllFoundDependencies();
                LOG.trace("New dependency set size: {}", (Object)newDependencySet.size());
                this.foundDependenciesMapped.set(newDependencySet);
            }
            catch (Exception e) {
                LOG.error("Problem  getting on pom operator", (Throwable)e);
            }
        });
        return DependencyUpdateResult.create(this.injectedDependencies, this.skippedDependencies, this.changesets, this.erroredFiles);
    }

    private boolean isEmptyPomFile(Path projectDir, Path file) throws IOException {
        this.maybePomFile = this.pomFileFinder.findForFile(projectDir, file);
        return this.maybePomFile.isEmpty();
    }

    private void modifyPomFiles(Path projectDir, ProjectModel modifiedProjectModel, DependencyGAV newDependencyGAV) {
        List<POMDocument> allPomFiles = modifiedProjectModel.allPomFiles();
        LOG.trace("Found {} pom files -- {}", (Object)allPomFiles.size(), allPomFiles);
        for (POMDocument aPomFile : allPomFiles) {
            URI uri = this.getPomFileURI(aPomFile);
            Path path = Path.of(uri);
            this.modifyDirtyPomFile(projectDir, path, aPomFile, newDependencyGAV);
        }
    }

    private void modifyDirtyPomFile(Path projectDir, Path path, POMDocument aPomFile, DependencyGAV newDependencyGAV) {
        if (!aPomFile.getDirty()) {
            LOG.trace("POM file {} wasn't dirty", (Object)path);
            return;
        }
        LOG.trace("POM file {} was dirty", (Object)path);
        try {
            CodeTFChangesetEntry entry = this.codeTFGenerator.getChanges(projectDir, aPomFile, newDependencyGAV);
            this.pomModifier.modify(path, aPomFile.getResultPomBytes());
            LOG.trace("POM written!");
            this.injectedDependencies.add(newDependencyGAV);
            this.changesets.add(entry);
        }
        catch (IOException | UncheckedIOException exc) {
            LOG.error("Failed to write pom", (Throwable)exc);
            this.erroredFiles.add(path);
        }
    }

    private URI getPomFileURI(POMDocument aPomFile) {
        try {
            return aPomFile.getPomPath().toURI();
        }
        catch (URISyntaxException ex) {
            LOG.error("Unexpected problem getting pom URI", (Throwable)ex);
            throw new MavenProvider.DependencyUpdateException("Failure parsing URL: " + aPomFile, ex);
        }
    }

    private boolean updateSkipDependencies(DependencyGAV newDependencyGAV) {
        LOG.trace("Looking at injecting new dependency: {}", (Object)newDependencyGAV);
        boolean foundIt = this.foundDependenciesMapped.get().stream().anyMatch(newDependencyGAV::equals);
        if (foundIt) {
            this.skippedDependencies.add(newDependencyGAV);
            return true;
        }
        return false;
    }
}

