/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven.operator;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.dom4j.Document;

public class POMDocument {
    private byte[] originalPom;
    private URL pomPath;
    private Document pomDocument;
    private Document resultPom;
    private Path path;
    private Charset charset;
    private String endl;
    private String indent;
    private byte[] resultPomBytes;
    private String preamble;
    private String suffix;
    private boolean dirty;

    public POMDocument(byte[] originalPom, URL pomPath, Document pomDocument) throws URISyntaxException {
        this.originalPom = originalPom;
        this.pomPath = pomPath;
        this.pomDocument = pomDocument;
        this.resultPom = (Document)pomDocument.clone();
        this.path = this.pomPath != null ? Paths.get(this.pomPath.toURI()) : null;
        this.charset = Charset.defaultCharset();
        this.endl = "\n";
        this.indent = "  ";
        this.resultPomBytes = new byte[0];
        this.preamble = "";
        this.suffix = "";
        this.dirty = false;
    }

    public POMDocument(byte[] originalPom, Document pomDocument) throws URISyntaxException {
        this(originalPom, null, pomDocument);
    }

    public String toString() {
        return this.pomPath == null ? "missing" : "[POMDocument @ " + this.pomPath.toString() + "]";
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public byte[] getOriginalPom() {
        return this.originalPom;
    }

    public void setOriginalPom(byte[] originalPom) {
        this.originalPom = originalPom;
    }

    public URL getPomPath() {
        return this.pomPath;
    }

    public void setPomPath(URL pomPath) {
        this.pomPath = pomPath;
    }

    public Document getPomDocument() {
        return this.pomDocument;
    }

    public void setPomDocument(Document pomDocument) {
        this.pomDocument = pomDocument;
    }

    public Document getResultPom() {
        return this.resultPom;
    }

    public void setResultPom(Document resultPom) {
        this.resultPom = resultPom;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path file) {
        this.path = file;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String getEndl() {
        return this.endl;
    }

    public void setEndl(String endl) {
        this.endl = endl;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public byte[] getResultPomBytes() {
        return this.resultPomBytes;
    }

    public void setResultPomBytes(byte[] resultPomBytes) {
        this.resultPomBytes = resultPomBytes;
    }

    public String getPreamble() {
        return this.preamble;
    }

    public void setPreamble(String preamble) {
        this.preamble = preamble;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

