/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven.operator;

import com.github.zafarkhaja.semver.Version;
import io.codemodder.DependencyGAV;
import io.codemodder.plugins.maven.operator.AbstractQueryCommand;
import io.codemodder.plugins.maven.operator.AbstractVersionCommand;
import io.codemodder.plugins.maven.operator.Command;
import io.codemodder.plugins.maven.operator.CommandChain;
import io.codemodder.plugins.maven.operator.Dependency;
import io.codemodder.plugins.maven.operator.FileUtils;
import io.codemodder.plugins.maven.operator.Kind;
import io.codemodder.plugins.maven.operator.POMScanner;
import io.codemodder.plugins.maven.operator.ProjectModel;
import io.codemodder.plugins.maven.operator.VersionDefinition;
import io.codemodder.plugins.maven.operator.VersionQueryResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.dom4j.DocumentException;
import org.jetbrains.annotations.NotNull;

public class POMOperator {
    private final POMScanner pomScanner;

    public POMOperator(Path pomFile, Path projectDir) {
        this.pomScanner = new POMScanner(pomFile, projectDir);
    }

    public POMScanner getPomScanner() {
        return this.pomScanner;
    }

    public ProjectModel addDependency(DependencyGAV newDependencyGAV) throws XMLStreamException, URISyntaxException, IOException, DocumentException {
        Dependency newDependency = new Dependency(newDependencyGAV);
        ProjectModel projectModel = this.pomScanner.scanFrom().withDependency(newDependency).withSkipIfNewer(true).withUseProperties(true).withRepositoryPath(FileUtils.createTempDirectoryWithPermissions()).build();
        return POMOperator.modify(projectModel) ? projectModel : null;
    }

    @NotNull
    public Collection<DependencyGAV> getAllFoundDependencies() throws DocumentException, IOException, URISyntaxException, XMLStreamException {
        ProjectModel originalProjectModel = this.pomScanner.scanFrom().withSafeQueryType().withRepositoryPath(FileUtils.createTempDirectoryWithPermissions()).build();
        Collection<Dependency> foundDependencies = POMOperator.queryDependency(originalProjectModel);
        return foundDependencies.stream().map(dependency -> DependencyGAV.createDefault((String)dependency.getGroupId(), (String)dependency.getArtifactId(), (String)dependency.getVersion())).toList();
    }

    static boolean modify(ProjectModel projectModel) throws URISyntaxException, IOException, XMLStreamException {
        return CommandChain.modifyDependency().execute(projectModel);
    }

    static boolean insertOnly(ProjectModel projectModel) throws URISyntaxException, IOException, XMLStreamException {
        return CommandChain.insertDependency().execute(projectModel);
    }

    static boolean updateOnly(ProjectModel projectModel) throws URISyntaxException, IOException, XMLStreamException {
        return CommandChain.updateDependency().execute(projectModel);
    }

    static Collection<Dependency> queryDependency(ProjectModel projectModel) throws URISyntaxException, IOException, XMLStreamException {
        return POMOperator.queryDependency(projectModel, Collections.emptyList());
    }

    static Optional<VersionQueryResponse> queryVersions(ProjectModel projectModel) throws URISyntaxException, IOException, XMLStreamException {
        Set<VersionDefinition> queryVersionResult = POMOperator.queryVersions(projectModel, Collections.emptyList());
        if (queryVersionResult.size() == 2) {
            if (queryVersionResult.stream().anyMatch(it -> it.getKind() == Kind.RELEASE)) {
                throw new IllegalStateException("Unexpected queryVersionResult Combination: " + queryVersionResult);
            }
            VersionDefinition queryVersionSource = queryVersionResult.stream().filter(it -> it.getKind() == Kind.SOURCE).findFirst().orElseThrow(() -> new IllegalStateException("Missing source version"));
            VersionDefinition queryVersionTarget = queryVersionResult.stream().filter(it -> it.getKind() == Kind.TARGET).findFirst().orElseThrow(() -> new IllegalStateException("Missing target version"));
            Version mappedSourceVersion = POMOperator.mapVersion(queryVersionSource.getValue());
            Version mappedTargetVersion = POMOperator.mapVersion(queryVersionTarget.getValue());
            return Optional.of(new VersionQueryResponse(mappedSourceVersion, mappedTargetVersion));
        }
        if (queryVersionResult.size() == 1) {
            List queryVersionResultList = queryVersionResult != null && !queryVersionResult.isEmpty() ? queryVersionResult.stream().toList() : Collections.emptyList();
            Version mappedVersion = POMOperator.mapVersion(((VersionDefinition)queryVersionResultList.get(0)).getValue());
            VersionQueryResponse returnValue = new VersionQueryResponse(mappedVersion, mappedVersion);
            return Optional.of(returnValue);
        }
        return Optional.empty();
    }

    private static Version mapVersion(String version) {
        String fixedVersion = version + (version.startsWith("1.") ? ".0" : ".0.0");
        return Version.valueOf((String)fixedVersion);
    }

    static Collection<Dependency> queryDependency(ProjectModel projectModel, List<Command> commandList) throws URISyntaxException, IOException, XMLStreamException {
        CommandChain chain = CommandChain.createForDependencyQuery(projectModel.getQueryType());
        POMOperator.executeChain(commandList, chain, projectModel);
        AbstractQueryCommand lastCommand = null;
        for (int i = chain.getCommandList().size() - 1; !(i < 0 || chain.getCommandList().get(i) instanceof AbstractQueryCommand && (lastCommand = (AbstractQueryCommand)chain.getCommandList().get(i)).getResult() != null); --i) {
        }
        if (lastCommand == null) {
            return Collections.emptyList();
        }
        return lastCommand.getResult();
    }

    static Set<VersionDefinition> queryVersions(ProjectModel projectModel, List<Command> commandList) throws URISyntaxException, IOException, XMLStreamException {
        CommandChain chain = CommandChain.createForVersionQuery(projectModel.getQueryType());
        POMOperator.executeChain(commandList, chain, projectModel);
        AbstractVersionCommand lastCommand = null;
        for (int i = chain.getCommandList().size() - 1; i >= 0; --i) {
            if (!(chain.getCommandList().get(i) instanceof AbstractVersionCommand)) continue;
            lastCommand = (AbstractVersionCommand)chain.getCommandList().get(i);
            if (lastCommand.result != null && !lastCommand.result.isEmpty()) break;
        }
        if (lastCommand == null) {
            return Collections.emptySet();
        }
        return lastCommand.result;
    }

    private static void executeChain(List<Command> commandList, CommandChain chain, ProjectModel projectModel) throws URISyntaxException, IOException, XMLStreamException {
        if (!commandList.isEmpty()) {
            chain.getCommandList().clear();
            chain.getCommandList().addAll(commandList);
        }
        chain.execute(projectModel);
    }
}

