/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven.operator;

import io.codemodder.plugins.maven.operator.POMDocument;
import io.codemodder.plugins.maven.operator.POMDocumentFactory;
import io.codemodder.plugins.maven.operator.ProjectModelFactory;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class POMScanner {
    private static final Pattern RE_WINDOWS_PATH = Pattern.compile("^[A-Za-z]:");
    private static final String ARTIFACT_ID = "artifactId";
    private static final Logger LOGGER = LoggerFactory.getLogger(POMScanner.class);
    private final Path originalPath;
    private final Path topLevelDirectory;
    private Path lastPath;

    public POMScanner(Path originalPath, Path topLevelDirectory) {
        this.originalPath = originalPath;
        this.topLevelDirectory = topLevelDirectory;
    }

    public ProjectModelFactory scanFrom() throws DocumentException, IOException, URISyntaxException {
        POMDocument pomFile = POMDocumentFactory.load(this.originalPath);
        ArrayList<POMDocument> parentPomFiles = new ArrayList<POMDocument>();
        LinkedList<Element> pomFileQueue = new LinkedList<Element>();
        Element relativePathElement = this.getRelativePathElement(pomFile);
        Element parentElement = this.getParentElement(pomFile);
        this.processRelativePathElement(relativePathElement, parentElement, this.originalPath, this.topLevelDirectory, pomFileQueue);
        this.lastPath = this.originalPath;
        HashSet<String> prevPaths = new HashSet<String>();
        POMDocument prevPOMDocument = pomFile;
        this.processPOMFileQueue(pomFileQueue, prevPaths, parentPomFiles, prevPOMDocument, pomFile);
        return ProjectModelFactory.loadFor(pomFile, parentPomFiles);
    }

    private void processPOMFileQueue(Queue<Element> pomFileQueue, Set<String> prevPaths, List<POMDocument> parentPomFiles, POMDocument prevPOMDocument, POMDocument pomFile) throws DocumentException, IOException, URISyntaxException {
        Path newPath;
        String relativePath;
        Element currentRelativePathElement;
        while (!pomFileQueue.isEmpty() && !StringUtils.isEmpty((CharSequence)(currentRelativePathElement = pomFileQueue.poll()).getTextTrim()) && this.processRelativePath(relativePath = this.fixPomRelativePath(currentRelativePathElement.getText()), prevPaths, pomFile) && this.validateNewPath(newPath = this.resolvePath(this.lastPath, relativePath), this.topLevelDirectory)) {
            POMDocument newPomFile = POMDocumentFactory.load(newPath);
            this.processParentAndRelativePathElements(newPomFile);
            if (!this.checkArtifactIdMatch(newPomFile, prevPOMDocument)) break;
            parentPomFiles.add(newPomFile);
            prevPOMDocument = newPomFile;
            Element newRelativePathElement = this.getRelativePathElement(newPomFile);
            if (newRelativePathElement == null) continue;
            pomFileQueue.add(newRelativePathElement);
        }
    }

    private Element getParentElement(POMDocument pomFile) {
        return pomFile.getPomDocument().getRootElement().element("parent");
    }

    private Element getRelativePathElement(POMDocument pomFile) {
        Element parentElement = this.getParentElement(pomFile);
        return parentElement != null ? parentElement.element("relativePath") : null;
    }

    private String getParentArtifactId(POMDocument prevPOMDocument) {
        Element parentElement = this.getParentElement(prevPOMDocument);
        return parentElement != null ? parentElement.element(ARTIFACT_ID).getText() : null;
    }

    private void processRelativePathElement(Element relativePathElement, Element parentElement, Path originalPath, Path topLevelDirectory, Queue<Element> pomFileQueue) {
        if (relativePathElement != null && StringUtils.isNotEmpty((CharSequence)relativePathElement.getTextTrim())) {
            pomFileQueue.add(relativePathElement);
        } else if (relativePathElement == null && parentElement != null && this.isNotRoot(originalPath, topLevelDirectory)) {
            this.addDefaultRelativePathElement(pomFileQueue);
        }
    }

    private boolean isNotRoot(Path originalPath, Path topLevelDirectory) {
        return !originalPath.getParent().equals(topLevelDirectory);
    }

    private DefaultElement createRelativePathElement() {
        DefaultElement newRelativePathElement = new DefaultElement("relativePath");
        newRelativePathElement.setText("../pom.xml");
        return newRelativePathElement;
    }

    private void addDefaultRelativePathElement(Queue<Element> pomFileQueue) {
        DefaultElement newRelativePathElement = this.createRelativePathElement();
        pomFileQueue.add((Element)newRelativePathElement);
    }

    private void processParentAndRelativePathElements(POMDocument newPomFile) {
        boolean hasRelativePath;
        boolean hasParent = this.getParentElement(newPomFile) != null;
        boolean bl = hasRelativePath = this.getRelativePathElement(newPomFile) != null;
        if (!hasRelativePath && hasParent) {
            Element parentElement = newPomFile.getPomDocument().getRootElement().element("parent");
            DefaultElement newRelativePathElement = this.createRelativePathElement();
            parentElement.add((Element)newRelativePathElement);
        }
    }

    private boolean processRelativePath(String relativePath, Set<String> prevPaths, POMDocument pomFile) {
        if (!this.isRelative(relativePath)) {
            LOGGER.debug("not relative: {}", (Object)relativePath);
            return false;
        }
        if (prevPaths.contains(relativePath)) {
            LOGGER.debug("loop: {}, relativePath: {}", (Object)pomFile.getPath(), (Object)relativePath);
            return false;
        }
        prevPaths.add(relativePath);
        return true;
    }

    private boolean validateNewPath(Path newPath, Path topLevelDirectory) {
        try {
            if (Files.notExists(newPath, new LinkOption[0])) {
                LOGGER.warn("new path does not exist: " + newPath);
                return false;
            }
            if (Files.size(newPath) == 0L) {
                LOGGER.warn("File has zero length: " + newPath);
                return false;
            }
            if (!newPath.startsWith(topLevelDirectory)) {
                LOGGER.warn("Not a child: " + newPath + " (absolute: " + topLevelDirectory.toAbsolutePath() + ")");
                return false;
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Error while validating path: " + newPath, (Throwable)e);
            return false;
        }
    }

    private boolean checkArtifactIdMatch(POMDocument newPomFile, POMDocument prevPOMDocument) {
        String myArtifactId = newPomFile.getPomDocument().getRootElement().element(ARTIFACT_ID) != null ? newPomFile.getPomDocument().getRootElement().element(ARTIFACT_ID).getText() : null;
        String prevParentArtifactId = this.getParentArtifactId(prevPOMDocument);
        if (myArtifactId == null || prevParentArtifactId == null) {
            LOGGER.warn("Missing previous mine or parent: " + myArtifactId + " / " + prevParentArtifactId);
            return false;
        }
        if (!myArtifactId.equals(prevParentArtifactId)) {
            LOGGER.warn("Previous doesn't match: " + myArtifactId + " / " + prevParentArtifactId);
            return false;
        }
        return true;
    }

    private Path resolvePath(Path baseFile, String relativePath) {
        Path parentDir = baseFile;
        if (parentDir != null && !Files.isDirectory(parentDir, new LinkOption[0])) {
            parentDir = parentDir.getParent();
        }
        assert (parentDir != null);
        Path result = parentDir.resolve(relativePath).normalize().toAbsolutePath();
        this.lastPath = Files.isDirectory(result, new LinkOption[0]) ? result : result.getParent();
        return result;
    }

    private String fixPomRelativePath(String text) {
        if (text == null) {
            return "";
        }
        String name = new File(text).getName();
        if (name.indexOf(46) == -1) {
            return text + "/pom.xml";
        }
        return text;
    }

    private boolean isRelative(String path) {
        if (RE_WINDOWS_PATH.matcher(path).matches()) {
            return false;
        }
        return !path.startsWith("/") && !path.startsWith("~");
    }
}

