/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven.operator;

import io.codemodder.plugins.maven.operator.Dependency;
import io.codemodder.plugins.maven.operator.POMDocument;
import io.codemodder.plugins.maven.operator.POMDocumentFactory;
import io.codemodder.plugins.maven.operator.ProjectModel;
import io.codemodder.plugins.maven.operator.QueryType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.dom4j.DocumentException;

class ProjectModelFactory {
    private POMDocument pomFile;
    private List<POMDocument> parentPomFiles = new ArrayList<POMDocument>();
    private Dependency dependency;
    private boolean skipIfNewer;
    private boolean useProperties;
    private Set<String> activeProfiles = new HashSet<String>();
    private boolean overrideIfAlreadyExists;
    private QueryType queryType = QueryType.NONE;
    private Path repositoryPath;

    private ProjectModelFactory() {
    }

    public ProjectModelFactory withPomFile(POMDocument pomFile) {
        this.pomFile = pomFile;
        return this;
    }

    public ProjectModelFactory withParentPomFiles(Collection<POMDocument> parentPomFiles) {
        this.parentPomFiles = new ArrayList<POMDocument>(parentPomFiles.stream().filter(Objects::nonNull).toList());
        return this;
    }

    public ProjectModelFactory withDependency(Dependency dep) {
        this.dependency = dep;
        return this;
    }

    public ProjectModelFactory withSkipIfNewer(boolean skipIfNewer) {
        this.skipIfNewer = skipIfNewer;
        return this;
    }

    public ProjectModelFactory withUseProperties(boolean useProperties) {
        this.useProperties = useProperties;
        return this;
    }

    public ProjectModelFactory withActiveProfiles(String ... activeProfiles) {
        this.activeProfiles = new HashSet<String>(Arrays.asList(activeProfiles));
        return this;
    }

    public ProjectModelFactory withOverrideIfAlreadyExists(boolean overrideIfAlreadyExists) {
        this.overrideIfAlreadyExists = overrideIfAlreadyExists;
        return this;
    }

    public ProjectModelFactory withSafeQueryType() {
        this.queryType = QueryType.SAFE;
        return this;
    }

    public ProjectModelFactory withRepositoryPath(Path repositoryPath) {
        this.repositoryPath = repositoryPath;
        return this;
    }

    private static ProjectModelFactory create() {
        return new ProjectModelFactory();
    }

    static ProjectModelFactory load(InputStream is) throws DocumentException, IOException, URISyntaxException {
        POMDocument pomDocument = POMDocumentFactory.load(is);
        return ProjectModelFactory.create().withPomFile(pomDocument);
    }

    static ProjectModelFactory load(Path filePath) throws Exception {
        URL fileUrl = filePath.toUri().toURL();
        return ProjectModelFactory.load(fileUrl);
    }

    static ProjectModelFactory load(URL url) throws DocumentException, IOException, URISyntaxException {
        POMDocument pomFile = POMDocumentFactory.load(url);
        return ProjectModelFactory.create().withPomFile(pomFile);
    }

    static ProjectModelFactory loadFor(POMDocument pomFile, Collection<POMDocument> parentPomFiles) {
        ArrayList<POMDocument> parentPomFilesList = new ArrayList<POMDocument>(parentPomFiles);
        ProjectModelFactory pmf = ProjectModelFactory.create();
        return ProjectModelFactory.create().withPomFile(pomFile).withParentPomFiles(parentPomFilesList);
    }

    public ProjectModel build() {
        return new ProjectModel(this.pomFile, this.parentPomFiles, this.dependency, this.skipIfNewer, this.useProperties, this.activeProfiles, this.overrideIfAlreadyExists, this.queryType, this.repositoryPath, null);
    }
}

