/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.plugins.maven.operator;

import com.github.zafarkhaja.semver.Version;
import io.codemodder.plugins.maven.operator.Dependency;
import io.codemodder.plugins.maven.operator.POMDocument;
import io.codemodder.plugins.maven.operator.ProjectModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.tree.DefaultText;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.dom4j.Dom4jXPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Util {
    private static final Logger LOGGER = LoggerFactory.getLogger(Util.class);
    private static final Pattern PROPERTY_REFERENCE_PATTERN = Pattern.compile("^\\$\\{(.*)}$");
    private static final SimpleNamespaceContext namespaceContext;

    private Util() {
    }

    static Element addIndentedElement(Element element, POMDocument d, String name) {
        Text lastElement;
        List contentList = element.content();
        int indentLevel = Util.findIndentLevel(element);
        String prefix = d.getEndl() + StringUtils.repeat((String)d.getIndent(), (int)(1 + indentLevel));
        String suffix = d.getEndl() + StringUtils.repeat((String)d.getIndent(), (int)indentLevel);
        if (!contentList.isEmpty() && contentList.get(contentList.size() - 1) instanceof Text && StringUtils.isWhitespace((CharSequence)(lastElement = (Text)contentList.get(contentList.size() - 1)).getText())) {
            contentList.remove(contentList.size() - 1);
        }
        contentList.add(new DefaultText(prefix));
        Element newElement = element.addElement(name);
        contentList.add(new DefaultText(suffix));
        d.setDirty(true);
        return newElement;
    }

    private static int findIndentLevel(Element startingNode) {
        int level = 0;
        Element node = startingNode;
        while (node.getParent() != null) {
            ++level;
            node = node.getParent();
        }
        return level;
    }

    static void upgradeVersionNode(ProjectModel c, Element versionNode, POMDocument pomDocumentHoldingProperty) {
        if (c.isUseProperties()) {
            String propertyName = Util.propertyName(c, versionNode);
            Util.upgradeProperty(c, pomDocumentHoldingProperty, propertyName);
            versionNode.setText(Util.escapedPropertyName(propertyName));
        } else if (c.getDependency() != null && c.getDependency().getVersion() != null) {
            String trimmedText;
            String nodeText = versionNode.getText();
            String string = trimmedText = nodeText != null ? nodeText.trim() : "";
            if (!trimmedText.equals(c.getDependency().getVersion())) {
                pomDocumentHoldingProperty.setDirty(true);
                versionNode.setText(c.getDependency().getVersion());
            }
        }
    }

    private static void upgradeProperty(ProjectModel c, POMDocument d, String propertyName) {
        String propertyText;
        Element parentPropertyElement;
        if (d.getResultPom().getRootElement().element("properties") == null) {
            Util.addIndentedElement(d.getResultPom().getRootElement(), d, "properties");
        }
        if ((parentPropertyElement = d.getResultPom().getRootElement().element("properties")).element(propertyName) == null) {
            Util.addIndentedElement(parentPropertyElement, d, propertyName);
        } else if (!c.isOverrideIfAlreadyExists()) {
            Pattern propertyReferencePattern = Pattern.compile("\\$\\{" + propertyName + "}");
            Matcher matcher = propertyReferencePattern.matcher(d.getResultPom().asXML());
            int numberOfAllCurrentMatches = 0;
            while (matcher.find()) {
                ++numberOfAllCurrentMatches;
            }
            if (numberOfAllCurrentMatches > 1) {
                throw new IllegalStateException("Property " + propertyName + " is already defined - and used more than once.");
            }
        }
        Element propertyElement = parentPropertyElement.element(propertyName);
        String string = propertyText = propertyElement.getText() != null ? propertyElement.getText().trim() : "";
        if (c.getDependency() != null && c.getDependency().getVersion() != null && !propertyText.equals(c.getDependency().getVersion())) {
            propertyElement.setText(c.getDependency().getVersion());
            d.setDirty(true);
        }
    }

    private static String escapedPropertyName(String propertyName) {
        return "${" + propertyName + "}";
    }

    static String propertyName(ProjectModel c, Element versionNode) {
        Matcher matcher;
        String version = versionNode.getTextTrim();
        if (PROPERTY_REFERENCE_PATTERN.matcher(version).matches() && (matcher = PROPERTY_REFERENCE_PATTERN.matcher(version)).find()) {
            return matcher.group(1);
        }
        if (c.getDependency() != null) {
            c.getDependency().getArtifactId();
            return "versions." + c.getDependency().getArtifactId();
        }
        return "versions.default";
    }

    static boolean findOutIfUpgradeIsNeeded(ProjectModel c, Element versionNode) {
        String currentVersionNodeText = Util.resolveVersion(c, versionNode.getText());
        Version currentVersion = Version.valueOf((String)currentVersionNodeText);
        Version newVersion = Version.valueOf((String)c.getDependency().getVersion());
        boolean versionsAreIncreasing = newVersion.greaterThan(currentVersion);
        return versionsAreIncreasing;
    }

    private static String resolveVersion(ProjectModel c, String versionText) {
        if (PROPERTY_REFERENCE_PATTERN.matcher(versionText).matches()) {
            StrSubstitutor substitutor = new StrSubstitutor(c.resolvedProperties());
            String resolvedVersion = substitutor.replace(versionText);
            return resolvedVersion;
        }
        return versionText;
    }

    static String buildLookupExpressionForDependency(Dependency dependency) {
        return "/m:project/m:dependencies/m:dependency[./m:groupId[text()='" + dependency.getGroupId() + "'] and ./m:artifactId[text()='" + dependency.getArtifactId() + "']]";
    }

    static String buildLookupExpressionForDependencyManagement(Dependency dependency) {
        return "/m:project/m:dependencyManagement/m:dependencies/m:dependency[./m:groupId[text()='" + dependency.getGroupId() + "'] and ./m:artifactId[text()='" + dependency.getArtifactId() + "']]";
    }

    static File which(String path) {
        List<Object> nativeExecutables;
        if (SystemUtils.IS_OS_WINDOWS) {
            nativeExecutables = new ArrayList<String>();
            nativeExecutables.add("");
            nativeExecutables.add(".exe");
            nativeExecutables.add(".bat");
            nativeExecutables.add(".cmd");
            nativeExecutables.replaceAll(ext -> path + ext);
        } else {
            nativeExecutables = Arrays.asList(path);
        }
        String pathContentString = System.getenv("PATH");
        String[] pathElements = pathContentString.split(File.pathSeparator);
        ArrayList<File> possiblePaths = new ArrayList<File>();
        for (String string : nativeExecutables) {
            for (String pathElement : pathElements) {
                possiblePaths.add(new File(new File(pathElement), string));
            }
        }
        Predicate<File> isCliCallable = SystemUtils.IS_OS_WINDOWS ? it -> it.exists() && it.isFile() : it -> it.exists() && it.isFile() && it.canExecute();
        File file = possiblePaths.stream().filter(isCliCallable).reduce((first, second) -> second).orElse(null);
        if (file == null) {
            LOGGER.warn("Unable to find mvn executable (execs: {}, path: {})", (Object)String.join((CharSequence)"/", nativeExecutables), (Object)pathContentString);
        }
        return file;
    }

    static List<Node> selectXPathNodes(Node node, String expression) {
        try {
            return Util.createXPathExpression(expression).selectNodes((Object)node);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Dom4jXPath createXPathExpression(String expression) throws Exception {
        Dom4jXPath xpath = new Dom4jXPath(expression);
        xpath.setNamespaceContext((NamespaceContext)namespaceContext);
        return xpath;
    }

    static {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("m", "http://maven.apache.org/POM/4.0.0");
        namespaceContext = new SimpleNamespaceContext(namespaces);
    }
}

