/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.sarif.semgrep;

import com.contrastsecurity.sarif.SarifSchema210;
import com.google.inject.AbstractModule;
import io.codemodder.CodeChanger;
import io.codemodder.RuleSarif;
import io.codemodder.providers.sarif.semgrep.ProvidedSemgrepScan;
import io.codemodder.providers.sarif.semgrep.SemgrepRuleSarif;
import io.codemodder.providers.sarif.semgrep.SemgrepRunner;
import io.codemodder.providers.sarif.semgrep.SemgrepScan;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SemgrepModule
extends AbstractModule {
    private final List<Class<? extends CodeChanger>> codemodTypes;
    private final Path codeDirectory;
    private final SemgrepRunner semgrepRunner;
    private final List<RuleSarif> sarifs;
    private static final Logger LOG = LoggerFactory.getLogger(SemgrepModule.class);

    @VisibleForTesting
    SemgrepModule(Path codeDirectory, List<Class<? extends CodeChanger>> codemodTypes) {
        this(codeDirectory, codemodTypes, List.of());
    }

    public SemgrepModule(Path codeDirectory, List<Class<? extends CodeChanger>> codemodTypes, List<RuleSarif> sarifs) {
        this.codemodTypes = Objects.requireNonNull(codemodTypes);
        this.codeDirectory = Objects.requireNonNull(codeDirectory);
        this.semgrepRunner = SemgrepRunner.createDefault();
        this.sarifs = Objects.requireNonNull(sarifs);
    }

    protected void configure() {
        SarifSchema210 sarif;
        ArrayList<Path> yamlPathsToRun = new ArrayList<Path>();
        ArrayList toBind = new ArrayList();
        HashSet<String> packagesScanned = new HashSet<String>();
        for (Class<? extends CodeChanger> codemodType : this.codemodTypes) {
            List<Parameter> targetedParamsForOfflineScanning;
            List<Parameter> targetedParamsForJustInTimeScanning;
            String packageName = codemodType.getPackageName();
            if (packagesScanned.contains(packageName)) continue;
            try (ScanResult scan = new ClassGraph().enableAllInfo().acceptPackagesNonRecursive(new String[]{packageName}).removeTemporaryFilesAfterScan().scan();){
                ClassInfoList classesWithMethodAnnotation = scan.getClassesWithMethodAnnotation(Inject.class);
                List injectableClasses = classesWithMethodAnnotation.loadClasses();
                List injectableParams = injectableClasses.stream().map(Class::getDeclaredConstructors).flatMap(Arrays::stream).filter(constructor -> constructor.isAnnotationPresent(Inject.class)).map(Executable::getParameters).flatMap(Arrays::stream).toList();
                targetedParamsForJustInTimeScanning = injectableParams.stream().filter(param -> param.isAnnotationPresent(SemgrepScan.class)).toList();
                targetedParamsForOfflineScanning = injectableParams.stream().filter(param -> param.isAnnotationPresent(ProvidedSemgrepScan.class)).toList();
            }
            targetedParamsForOfflineScanning.forEach(param -> {
                if (!RuleSarif.class.equals(param.getType())) {
                    throw new IllegalArgumentException("can't use @ProvidedSemgrepScan on anything except RuleSarif (see " + param.getDeclaringExecutable().getDeclaringClass().getName() + ")");
                }
                ProvidedSemgrepScan annotation = param.getAnnotation(ProvidedSemgrepScan.class);
                RuleSarif ruleSarif = this.sarifs.stream().filter(sarif -> sarif.getRule().equals(annotation.ruleId())).findFirst().orElse(RuleSarif.EMPTY);
                this.bind(RuleSarif.class).annotatedWith((Annotation)annotation).toInstance((Object)ruleSarif);
            });
            targetedParamsForJustInTimeScanning.forEach(param -> {
                String inlineYaml;
                if (!RuleSarif.class.equals(param.getType())) {
                    throw new IllegalArgumentException("can't use @SemgrepScan on anything except RuleSarif (see " + param.getDeclaringExecutable().getDeclaringClass().getName() + ")");
                }
                SemgrepScan semgrepScan = param.getAnnotation(SemgrepScan.class);
                String yamlPath = semgrepScan.pathToYaml();
                String declaredRuleId = semgrepScan.ruleId();
                Path yamlPathToWrite = null;
                boolean foundYaml = false;
                if (!declaredRuleId.isEmpty()) {
                    Optional<Path> path;
                    Object classpathYamlPath = "/" + packageName.replace(".", "/") + "/" + declaredRuleId + ".yaml";
                    if (!"".equals(yamlPath)) {
                        classpathYamlPath = yamlPath;
                    }
                    if ((path = this.saveClasspathResourceToTemp(codemodType, (String)classpathYamlPath)).isPresent()) {
                        foundYaml = true;
                        yamlPathToWrite = path.get();
                    }
                }
                if (!"".equals(inlineYaml = semgrepScan.yaml())) {
                    if (foundYaml) {
                        throw new IllegalArgumentException("Cannot specify both inline yaml and yaml file path: " + codemodType.getName());
                    }
                    foundYaml = true;
                    yamlPathToWrite = this.saveStringToTemp(inlineYaml);
                }
                if (!foundYaml) {
                    throw new IllegalArgumentException("no semgrep yaml found for: " + codemodType.getName());
                }
                try {
                    if (StringUtils.isEmpty((CharSequence)declaredRuleId)) {
                        String rawYaml = Files.readString(yamlPathToWrite);
                        declaredRuleId = this.detectSingleRuleFromYaml(rawYaml);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Problem inspecting yaml: " + codemodType.getName(), e);
                }
                yamlPathsToRun.add(yamlPathToWrite);
                Pair rulePair = Pair.of((Object)declaredRuleId, (Object)semgrepScan);
                toBind.add(rulePair);
            });
            LOG.debug("Finished scanning codemod package: {}", (Object)packageName);
            packagesScanned.add(packageName);
        }
        if (toBind.isEmpty()) {
            return;
        }
        for (Path yamlPath : yamlPathsToRun) {
            try {
                boolean changed = false;
                Object yamlAsString = Files.readString(yamlPath);
                if (!((String)yamlAsString).contains("message:")) {
                    changed = true;
                    yamlAsString = (String)yamlAsString + "\n    message: Semgrep found a match\n";
                }
                if (!((String)yamlAsString).contains("severity:")) {
                    changed = true;
                    yamlAsString = (String)yamlAsString + "\n    severity: WARNING\n";
                }
                if (!((String)yamlAsString).contains("languages:")) {
                    changed = true;
                    yamlAsString = (String)yamlAsString + "\n    languages:\n      - java\n";
                }
                if (!changed) continue;
                Files.writeString(yamlPath, (CharSequence)yamlAsString, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Problem fixing up yaml", e);
            }
        }
        try {
            sarif = this.semgrepRunner.run(yamlPathsToRun, this.codeDirectory);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Semgrep execution failed", e);
        }
        for (Pair bindingPair : toBind) {
            SemgrepScan sarifAnnotation = (SemgrepScan)bindingPair.getRight();
            SemgrepRuleSarif semgrepSarif = new SemgrepRuleSarif((String)bindingPair.getLeft(), sarif, this.codeDirectory);
            this.bind(RuleSarif.class).annotatedWith((Annotation)sarifAnnotation).toInstance((Object)semgrepSarif);
        }
        for (Path yamlFile : yamlPathsToRun) {
            try {
                Files.delete(yamlFile);
            }
            catch (IOException e) {
                LOG.warn("Failed to delete temporary file: {}", (Object)yamlFile, (Object)e);
            }
        }
    }

    @VisibleForTesting
    String detectSingleRuleFromYaml(String rawYaml) {
        String ruleIdStartToken = "- id:";
        int count = StringUtils.countMatches((CharSequence)rawYaml, (CharSequence)ruleIdStartToken);
        if (count > 1) {
            throw new IllegalArgumentException("Multiple rules found in yaml, must specify rule single rule id if implicit");
        }
        if (count == 0) {
            throw new IllegalArgumentException("No rules found in yaml, must specify rule single rule id if implicit");
        }
        int start = rawYaml.indexOf(ruleIdStartToken);
        int end = rawYaml.indexOf("\n", start);
        return rawYaml.substring(start + ruleIdStartToken.length(), end).trim();
    }

    private Path saveStringToTemp(String yamlAsString) {
        try {
            Path file = Files.createTempFile("semgrep", ".yaml", new FileAttribute[0]);
            Files.writeString(file, (CharSequence)yamlAsString, new OpenOption[0]);
            return file;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Problem saving yaml string to temp", e);
        }
    }

    private Optional<Path> saveClasspathResourceToTemp(Class<?> codemodType, String yamlClasspathResourcePath) {
        InputStream ruleInputStream = codemodType.getResourceAsStream(yamlClasspathResourcePath);
        if (ruleInputStream == null) {
            return Optional.empty();
        }
        try {
            Path semgrepRuleFile = Files.createTempFile("semgrep", ".yaml", new FileAttribute[0]);
            Objects.requireNonNull(ruleInputStream);
            Files.copy(ruleInputStream, semgrepRuleFile, StandardCopyOption.REPLACE_EXISTING);
            ruleInputStream.close();
            Optional<Path> optional = Optional.of(semgrepRuleFile);
            return optional;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Problem reading/copying semgrep yaml from classpath", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)ruleInputStream);
        }
    }
}

