/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.sarif.semgrep;

import io.codemodder.CodeChanger;
import io.codemodder.providers.sarif.semgrep.SemgrepRule;
import io.codemodder.providers.sarif.semgrep.SemgrepRuleFactory;
import io.codemodder.providers.sarif.semgrep.SemgrepScan;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

final class DefaultSemgrepRuleFactory
implements SemgrepRuleFactory {
    private static final String YAML = ".yaml";

    DefaultSemgrepRuleFactory() {
    }

    @Override
    public SemgrepRule createRule(Class<? extends CodeChanger> codemodType, SemgrepScan semgrepScan, String packageName) {
        String inlineYaml;
        String yamlPath = semgrepScan.pathToYaml();
        String declaredRuleId = semgrepScan.ruleId();
        Path yamlPathToWrite = null;
        boolean foundYaml = false;
        if (!declaredRuleId.isEmpty()) {
            Optional<Path> path;
            Object classpathYamlPath = "/" + packageName.replace(".", "/") + "/" + declaredRuleId + YAML;
            if (!"".equals(yamlPath)) {
                classpathYamlPath = yamlPath;
            }
            if ((path = this.saveClasspathResourceToTemp(codemodType, (String)classpathYamlPath)).isPresent()) {
                foundYaml = true;
                yamlPathToWrite = path.get();
            }
        }
        if (!"".equals(inlineYaml = semgrepScan.yaml())) {
            if (foundYaml) {
                throw new IllegalArgumentException("Cannot specify both inline yaml and yaml file path: " + codemodType.getName());
            }
            foundYaml = true;
            yamlPathToWrite = this.saveStringToTemp(inlineYaml);
        }
        if (!foundYaml) {
            throw new IllegalArgumentException("no semgrep yaml found for: " + codemodType.getName());
        }
        try {
            if (StringUtils.isEmpty((CharSequence)declaredRuleId)) {
                String rawYaml = Files.readString(yamlPathToWrite);
                declaredRuleId = DefaultSemgrepRuleFactory.detectSingleRuleFromYaml(rawYaml);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Problem inspecting yaml: " + codemodType.getName(), e);
        }
        try {
            this.addMissingPropertiesIfNeeded(yamlPathToWrite);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Problem fixing up yaml: " + codemodType.getName(), e);
        }
        return new SemgrepRule(semgrepScan, declaredRuleId, yamlPathToWrite);
    }

    private void addMissingPropertiesIfNeeded(Path yamlPathToWrite) throws IOException {
        boolean changed = false;
        Object yamlAsString = Files.readString(yamlPathToWrite);
        if (!((String)yamlAsString).contains("message:")) {
            changed = true;
            yamlAsString = (String)yamlAsString + "\n    message: Semgrep found a match\n";
        }
        if (!((String)yamlAsString).contains("severity:")) {
            changed = true;
            yamlAsString = (String)yamlAsString + "\n    severity: WARNING\n";
        }
        if (!((String)yamlAsString).contains("languages:")) {
            changed = true;
            yamlAsString = (String)yamlAsString + "\n    languages:\n      - java\n";
        }
        if (changed) {
            Files.writeString(yamlPathToWrite, (CharSequence)yamlAsString, StandardOpenOption.TRUNCATE_EXISTING);
        }
    }

    private Path saveStringToTemp(String yamlAsString) {
        try {
            Path file = Files.createTempFile("semgrep", YAML, new FileAttribute[0]);
            Files.writeString(file, (CharSequence)yamlAsString, new OpenOption[0]);
            return file;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Problem saving yaml string to temp", e);
        }
    }

    private Optional<Path> saveClasspathResourceToTemp(Class<?> codemodType, String yamlClasspathResourcePath) {
        InputStream ruleInputStream = codemodType.getResourceAsStream(yamlClasspathResourcePath);
        if (ruleInputStream == null) {
            return Optional.empty();
        }
        try {
            Path semgrepRuleFile = Files.createTempFile("semgrep", YAML, new FileAttribute[0]);
            Objects.requireNonNull(ruleInputStream);
            Files.copy(ruleInputStream, semgrepRuleFile, StandardCopyOption.REPLACE_EXISTING);
            ruleInputStream.close();
            Optional<Path> optional = Optional.of(semgrepRuleFile);
            return optional;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Problem reading/copying semgrep yaml from classpath", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)ruleInputStream);
        }
    }

    @VisibleForTesting
    static String detectSingleRuleFromYaml(String rawYaml) {
        String ruleIdStartToken = "- id:";
        int count = StringUtils.countMatches((CharSequence)rawYaml, (CharSequence)ruleIdStartToken);
        if (count > 1) {
            throw new IllegalArgumentException("Multiple rules found in yaml, must specify rule single rule id if implicit");
        }
        if (count == 0) {
            throw new IllegalArgumentException("No rules found in yaml, must specify rule single rule id if implicit");
        }
        int start = rawYaml.indexOf(ruleIdStartToken);
        int end = rawYaml.indexOf("\n", start);
        return rawYaml.substring(start + ruleIdStartToken.length(), end).trim();
    }
}

