package io.codemodder.providers.sarif.semgrep;

import com.github.javaparser.ast.Node;
import io.codemodder.CodemodReporterStrategy;
import io.codemodder.FixOnlyCodeChanger;
import io.codemodder.RegionNodeMatcher;
import io.codemodder.RuleSarif;
import io.codemodder.SarifPluginJavaParserChanger;

/**
 * Provides foundational functionality for modifying Java code using JavaParser based on findings
 * from a SARIF file generated by Semgrep analysis.
 */
public abstract class SemgrepSarifJavaParserChanger<T extends Node>
    extends SarifPluginJavaParserChanger<T> implements FixOnlyCodeChanger {

  protected SemgrepSarifJavaParserChanger(
      final RuleSarif sarif,
      final Class<? extends Node> nodeType,
      final RegionNodeMatcher regionNodeMatcher,
      final CodemodReporterStrategy reporterStrategy) {
    super(sarif, nodeType, regionNodeMatcher, reporterStrategy);
  }

  @Override
  public String vendorName() {
    return "Semgrep";
  }
}
