/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.sarif.semgrep;

import com.contrastsecurity.sarif.Run;
import com.contrastsecurity.sarif.SarifSchema210;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.codemodder.providers.sarif.semgrep.SemgrepRunner;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultSemgrepRunner
implements SemgrepRunner {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final String OUR_SEMGREPIGNORE_CONTENTS = "# dont ignore anything";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSemgrepRunner.class);

    DefaultSemgrepRunner() {
    }

    @Override
    public SarifSchema210 run(List<Path> ruleYamls, Path repository, List<String> includePatterns, List<String> excludePatterns) throws IOException {
        Path repositoryPath = repository.toAbsolutePath();
        Path sarifFile = Files.createTempFile("semgrep", ".sarif", new FileAttribute[0]);
        LOG.trace("Repository: {}", (Object)this.dumpInfo(repositoryPath));
        ArrayList<String> args = new ArrayList<String>();
        args.add("semgrep");
        args.add("--no-error");
        args.add("--dataflow-traces");
        args.add("--sarif");
        args.add("-o");
        args.add(sarifFile.toAbsolutePath().toString());
        for (String includedFilePath : includePatterns) {
            args.add("--include");
            args.add(includedFilePath);
        }
        for (String excludedFilePath : excludePatterns) {
            args.add("--exclude");
            args.add(excludedFilePath);
        }
        for (Path ruleYaml : ruleYamls) {
            args.add("--config");
            args.add(ruleYaml.toString());
        }
        args.add(repositoryPath.toString());
        LOG.trace("Process arguments: {}", args);
        Path tmpDir = Files.createTempDirectory("codemodder-semgrep", new FileAttribute[0]);
        Path semgrepIgnoreFile = Files.createFile(tmpDir.resolve(".semgrepignore"), new FileAttribute[0]);
        Files.writeString(semgrepIgnoreFile, (CharSequence)OUR_SEMGREPIGNORE_CONTENTS, new OpenOption[0]);
        LOG.trace("Will execute Semgrep from this directory: {}", (Object)this.dumpInfo(tmpDir));
        LOG.trace("Semgrep ignore file is located at: {}", (Object)this.dumpInfo(semgrepIgnoreFile));
        LOG.trace("SARIF file will be located at: {}", (Object)this.dumpInfo(sarifFile));
        Path semgrepHome = Files.createTempDirectory("semgrep-home", new FileAttribute[0]).toAbsolutePath();
        LOG.trace("Semgrep home will be: {}", (Object)this.dumpInfo(semgrepHome));
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.environment().put("HOME", semgrepHome.toString());
        Process p = pb.directory(tmpDir.toFile()).start();
        try {
            int rc = p.waitFor();
            LOG.trace("Semgrep return code: {}", (Object)rc);
            if (rc != 0) {
                throw new RuntimeException("error code seen from semgrep execution: " + rc);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("problem waiting for semgrep process execution", e);
        }
        SarifSchema210 sarif = (SarifSchema210)this.objectMapper.readValue(Files.newInputStream(sarifFile, new OpenOption[0]), SarifSchema210.class);
        LOG.trace("SARIF results: {}", (Object)((Run)sarif.getRuns().get(0)).getResults().size());
        Files.delete(semgrepIgnoreFile);
        Files.delete(tmpDir);
        Files.delete(sarifFile);
        return sarif;
    }

    private String dumpInfo(Path path) {
        File file = path.toFile();
        return path + " (canRead=" + file.canRead() + ", canWrite=" + file.canWrite() + ")";
    }
}

