/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.sarif.semgrep;

import com.contrastsecurity.sarif.Result;
import com.contrastsecurity.sarif.Run;
import com.contrastsecurity.sarif.SarifSchema210;
import com.google.inject.AbstractModule;
import io.codemodder.CodeChanger;
import io.codemodder.LazyLoadingRuleSarif;
import io.codemodder.RuleSarif;
import io.codemodder.providers.sarif.semgrep.DefaultSemgrepRuleFactory;
import io.codemodder.providers.sarif.semgrep.ProvidedSemgrepScan;
import io.codemodder.providers.sarif.semgrep.SemgrepRule;
import io.codemodder.providers.sarif.semgrep.SemgrepRuleFactory;
import io.codemodder.providers.sarif.semgrep.SemgrepRunner;
import io.codemodder.providers.sarif.semgrep.SemgrepScan;
import io.codemodder.providers.sarif.semgrep.SingleSemgrepRuleSarif;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SemgrepModule
extends AbstractModule {
    private final List<Class<? extends CodeChanger>> codemodTypes;
    private final Path codeDirectory;
    private final SemgrepRunner semgrepRunner;
    private final List<RuleSarif> sarifs;
    private final List<String> includePatterns;
    private final List<String> excludePatterns;
    private final SemgrepRuleFactory semgrepRuleFactory;
    private static final Logger LOG = LoggerFactory.getLogger(SemgrepModule.class);

    public SemgrepModule(Path codeDirectory, List<String> includePatterns, List<String> excludePatterns, List<Class<? extends CodeChanger>> codemodTypes) {
        this(codeDirectory, includePatterns, excludePatterns, codemodTypes, List.of(), new DefaultSemgrepRuleFactory());
    }

    public SemgrepModule(Path codeDirectory, List<String> includePatterns, List<String> excludePatterns, List<Class<? extends CodeChanger>> codemodTypes, List<RuleSarif> sarifs, SemgrepRuleFactory semgrepRuleFactory) {
        this.codemodTypes = Objects.requireNonNull(codemodTypes);
        this.codeDirectory = Objects.requireNonNull(codeDirectory);
        this.includePatterns = Objects.requireNonNull(includePatterns);
        this.excludePatterns = Objects.requireNonNull(excludePatterns);
        this.semgrepRunner = SemgrepRunner.createDefault();
        this.sarifs = Objects.requireNonNull(sarifs);
        this.semgrepRuleFactory = Objects.requireNonNull(semgrepRuleFactory);
    }

    protected void configure() {
        List<String> rawRulesFoundInBatchRun;
        HashSet<String> packagesScanned = new HashSet<String>();
        ArrayList rules = new ArrayList();
        for (Class<? extends CodeChanger> codemodType : this.codemodTypes) {
            List<Parameter> targetedParamsForOfflineScanning;
            List<Parameter> targetedParamsForJustInTimeScanning;
            String packageName = codemodType.getPackageName();
            if (packagesScanned.contains(packageName)) continue;
            try (ScanResult scan = new ClassGraph().enableAllInfo().acceptPackagesNonRecursive(new String[]{packageName}).removeTemporaryFilesAfterScan().scan();){
                ClassInfoList classesWithMethodAnnotation = scan.getClassesWithMethodAnnotation(Inject.class);
                List injectableClasses = classesWithMethodAnnotation.loadClasses();
                List injectableParams = injectableClasses.stream().map(Class::getDeclaredConstructors).flatMap(Arrays::stream).filter(constructor -> constructor.isAnnotationPresent(Inject.class)).map(Executable::getParameters).flatMap(Arrays::stream).toList();
                targetedParamsForJustInTimeScanning = injectableParams.stream().filter(param -> param.isAnnotationPresent(SemgrepScan.class)).toList();
                targetedParamsForOfflineScanning = injectableParams.stream().filter(param -> param.isAnnotationPresent(ProvidedSemgrepScan.class)).toList();
            }
            targetedParamsForOfflineScanning.forEach(param -> {
                if (!RuleSarif.class.equals(param.getType())) {
                    throw new IllegalArgumentException("can't use @ProvidedSemgrepScan on anything except RuleSarif (see " + param.getDeclaringExecutable().getDeclaringClass().getName() + ")");
                }
                ProvidedSemgrepScan annotation = param.getAnnotation(ProvidedSemgrepScan.class);
                RuleSarif ruleSarif = this.sarifs.stream().filter(sarif -> sarif.getRule().equals(annotation.ruleId())).findFirst().orElse(RuleSarif.EMPTY);
                this.bind(RuleSarif.class).annotatedWith((Annotation)annotation).toInstance((Object)ruleSarif);
            });
            targetedParamsForJustInTimeScanning.forEach(param -> {
                if (!RuleSarif.class.equals(param.getType())) {
                    throw new IllegalArgumentException("can't use @SemgrepScan on anything except RuleSarif (see " + param.getDeclaringExecutable().getDeclaringClass().getName() + ")");
                }
                SemgrepScan semgrepScan = param.getAnnotation(SemgrepScan.class);
                SemgrepRule rule = this.semgrepRuleFactory.createRule(codemodType, semgrepScan, packageName);
                rules.add(rule);
            });
            LOG.trace("Finished scanning codemod package: {}", (Object)packageName);
            packagesScanned.add(packageName);
        }
        try {
            SarifSchema210 allRulesSarif = this.semgrepRunner.run(rules.stream().map(SemgrepRule::yaml).toList(), this.codeDirectory, this.includePatterns, this.excludePatterns);
            rawRulesFoundInBatchRun = ((Run)allRulesSarif.getRuns().get(0)).getResults().stream().map(Result::getRuleId).toList();
        }
        catch (IOException e) {
            throw new UncheckedIOException("problem running batched execution", e);
        }
        for (SemgrepRule rule : rules) {
            SemgrepScan semgrepScan = rule.semgrepScan();
            if (rawRulesFoundInBatchRun.stream().anyMatch(r -> r.endsWith("." + rule.ruleId()))) {
                SemgrepSarifProvider semgrepSarifProvider = new SemgrepSarifProvider(this.codeDirectory, this.includePatterns, this.excludePatterns, this.semgrepRunner, rule.yaml(), rule.ruleId());
                LazyLoadingRuleSarif lazyLoadingRuleSarif = new LazyLoadingRuleSarif((Provider)semgrepSarifProvider);
                this.bind(RuleSarif.class).annotatedWith((Annotation)semgrepScan).toInstance((Object)lazyLoadingRuleSarif);
                continue;
            }
            this.bind(RuleSarif.class).annotatedWith((Annotation)semgrepScan).toInstance((Object)RuleSarif.EMPTY);
        }
    }

    private record SemgrepSarifProvider(Path codeDirectory, List<String> includePatterns, List<String> excludePatterns, SemgrepRunner semgrepRunner, Path yaml, String ruleId) implements Provider<RuleSarif>
    {
        SemgrepSarifProvider {
            Objects.requireNonNull(semgrepRunner);
            Objects.requireNonNull(codeDirectory);
            Objects.requireNonNull(includePatterns);
            Objects.requireNonNull(excludePatterns);
        }

        public RuleSarif get() {
            SarifSchema210 sarif;
            try {
                sarif = this.semgrepRunner.run(List.of(this.yaml), this.codeDirectory, this.includePatterns, this.excludePatterns);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Semgrep execution failed", e);
            }
            SingleSemgrepRuleSarif semgrepSarif = new SingleSemgrepRuleSarif(this.ruleId, sarif, this.codeDirectory);
            try {
                Files.delete(this.yaml);
            }
            catch (IOException e) {
                LOG.warn("Failed to delete temporary file: {}", (Object)this.yaml, (Object)e);
            }
            return semgrepSarif;
        }
    }
}

