/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.sonar;

import com.google.inject.AbstractModule;
import io.codemodder.CodeChanger;
import io.codemodder.providers.sonar.ProvidedSonarScan;
import io.codemodder.providers.sonar.RuleFinding;
import io.codemodder.providers.sonar.RuleHotspot;
import io.codemodder.providers.sonar.RuleIssue;
import io.codemodder.sonar.model.Hotspot;
import io.codemodder.sonar.model.Issue;
import io.codemodder.sonar.model.SonarFinding;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

final class SonarModule<T extends SonarFinding>
extends AbstractModule {
    private final List<Class<? extends CodeChanger>> codemodTypes;
    private final Path repository;
    private final List<T> sonarFindings;
    private final Class<? extends RuleFinding<T>> ruleFindingClass;

    SonarModule(List<Class<? extends CodeChanger>> codemodTypes, Path repository, List<T> findings, Class<? extends RuleFinding<T>> ruleFindingClass) {
        this.codemodTypes = Objects.requireNonNull(codemodTypes);
        this.repository = Objects.requireNonNull(repository);
        this.sonarFindings = findings;
        this.ruleFindingClass = ruleFindingClass;
    }

    protected void configure() {
        Map<String, List<T>> findingsByRuleMap = this.groupFindingsByRule(this.sonarFindings);
        HashSet<String> packagesScanned = new HashSet<String>();
        for (Class<? extends CodeChanger> codemodType : this.codemodTypes) {
            String packageName = codemodType.getPackageName();
            if (packagesScanned.contains(packageName)) continue;
            packagesScanned.add(packageName);
            this.bindAnnotationsForPackage(packageName, findingsByRuleMap);
        }
    }

    private Map<String, List<T>> groupFindingsByRule(List<T> findings) {
        HashMap findingsByRuleMap = new HashMap();
        findings.forEach(finding -> {
            String rule = finding.rule();
            List perRuleList = findingsByRuleMap.computeIfAbsent(rule, k -> new ArrayList());
            perRuleList.add(finding);
        });
        return findingsByRuleMap;
    }

    private void bindAnnotationsForPackage(String packageName, Map<String, List<T>> findingsByRuleMap) {
        try (ScanResult scan = new ClassGraph().enableAllInfo().acceptPackagesNonRecursive(new String[]{packageName}).removeTemporaryFilesAfterScan().scan();){
            List<Parameter> injectableParams = this.getInjectableParameters(scan);
            HashMap boundRuleIds = new HashMap();
            injectableParams.forEach(param -> {
                ProvidedSonarScan annotation = param.getAnnotation(ProvidedSonarScan.class);
                if (annotation != null && this.ruleFindingClass.equals(param.getType())) {
                    this.bindParam(annotation, (Parameter)param, findingsByRuleMap, boundRuleIds);
                }
            });
        }
    }

    private List<Parameter> getInjectableParameters(ScanResult scan) {
        ClassInfoList classesWithMethodAnnotation = scan.getClassesWithMethodAnnotation(Inject.class);
        List injectableClasses = classesWithMethodAnnotation.loadClasses();
        return injectableClasses.stream().map(Class::getDeclaredConstructors).flatMap(Arrays::stream).filter(constructor -> constructor.isAnnotationPresent(Inject.class)).map(Executable::getParameters).flatMap(Arrays::stream).toList();
    }

    private void bindParam(ProvidedSonarScan annotation, Parameter param, Map<String, List<T>> findingsByRuleMap, Map<String, Boolean> boundRuleIds) {
        if (!RuleFinding.class.isAssignableFrom(param.getType())) {
            throw new IllegalArgumentException("can't use @ProvidedSonarScan on anything except RuleFinding (see " + param.getDeclaringExecutable().getDeclaringClass().getName() + ")");
        }
        String ruleId = annotation.ruleId();
        if (boundRuleIds.containsKey(ruleId)) {
            return;
        }
        List<Issue> findings = findingsByRuleMap.getOrDefault(ruleId, Collections.emptyList());
        if (RuleIssue.class.equals(this.ruleFindingClass)) {
            if (findings.isEmpty()) {
                this.bind(RuleIssue.class).annotatedWith((Annotation)annotation).toInstance((Object)new RuleIssue(List.of(), this.repository));
            } else {
                this.bind(RuleIssue.class).annotatedWith((Annotation)annotation).toInstance((Object)new RuleIssue(findings, this.repository));
            }
        } else if (RuleHotspot.class.equals(this.ruleFindingClass)) {
            if (findings.isEmpty()) {
                this.bind(RuleHotspot.class).annotatedWith((Annotation)annotation).toInstance((Object)new RuleHotspot(List.of(), this.repository));
            } else {
                this.bind(RuleHotspot.class).annotatedWith((Annotation)annotation).toInstance((Object)new RuleHotspot((List<Hotspot>)findings, this.repository));
            }
        }
        boundRuleIds.put(ruleId, true);
    }
}

