/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.sonar.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.codemodder.sonar.model.Flow;
import io.codemodder.sonar.model.SonarSeverity;
import io.codemodder.sonar.model.TextRange;
import io.codemodder.sonar.model.update.FindingSeverity;
import java.util.List;
import java.util.Optional;

public abstract class SonarFinding {
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="line")
    private int line;
    @JsonProperty(value="effort")
    private String effort;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="resolution")
    private String resolution;
    @JsonProperty(value="textRange")
    private TextRange textRange;
    @JsonProperty(value="component")
    private String component;
    @JsonProperty(value="severity")
    private SonarSeverity severity;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="flows")
    private List<Flow> flows;

    public List<Flow> getFlows() {
        return this.flows;
    }

    public FindingSeverity getSeverity() {
        return this.severity != null ? this.severity.toSeverity() : null;
    }

    public int getLine() {
        return this.line;
    }

    public String getMessage() {
        return this.message;
    }

    public String getKey() {
        return this.key;
    }

    public TextRange getTextRange() {
        return this.textRange;
    }

    public Optional<String> componentFileName() {
        if (this.component == null || this.component.isEmpty()) {
            return Optional.empty();
        }
        String[] parts = this.component.split(":");
        if (parts.length != 2) {
            return Optional.empty();
        }
        return Optional.of(parts[1]);
    }

    public abstract String typeName();

    public abstract String rule();
}

