/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeUtils {
    private static final Logger log = LoggerFactory.getLogger(TimeUtils.class);

    public static Clock getClock() {
        return Clock.systemUTC();
    }

    public static <RESULT> RESULT time(Callable<RESULT> func) {
        long start = System.currentTimeMillis();
        RESULT call = func.call();
        long elapsed = System.currentTimeMillis() - start;
        log.trace("Function took {}", (Object)Duration.ofMillis(elapsed));
        return call;
    }

    private TimeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

