/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.offsets;

import io.confluent.parallelconsumer.internal.InternalRuntimeError;
import io.confluent.parallelconsumer.offsets.OffsetBitSet;
import io.confluent.parallelconsumer.offsets.OffsetEncoding;
import io.confluent.parallelconsumer.offsets.OffsetMapCodecManager;
import io.confluent.parallelconsumer.offsets.OffsetRunLength;
import io.confluent.parallelconsumer.offsets.OffsetSimpleSerialisation;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EncodedOffsetPair
implements Comparable<EncodedOffsetPair> {
    private static final Logger log = LoggerFactory.getLogger(EncodedOffsetPair.class);
    public static final Comparator<EncodedOffsetPair> SIZE_COMPARATOR = Comparator.comparingInt(x -> x.data.capacity());
    OffsetEncoding encoding;
    ByteBuffer data;

    EncodedOffsetPair(OffsetEncoding encoding, ByteBuffer data) {
        this.encoding = encoding;
        this.data = data;
    }

    @Override
    public int compareTo(EncodedOffsetPair o) {
        return SIZE_COMPARATOR.compare(this, o);
    }

    public String toString() {
        return "\n{" + this.encoding.name() + ", \t\t\tsize=" + this.data.capacity() + "}";
    }

    public byte[] readDataArrayForDebug() {
        return EncodedOffsetPair.copyBytesOutOfBufferForDebug(this.data);
    }

    private static byte[] copyBytesOutOfBufferForDebug(ByteBuffer bbData) {
        bbData.position(0);
        byte[] bytes = new byte[bbData.remaining()];
        bbData.get(bytes, 0, bbData.limit());
        return bytes;
    }

    static EncodedOffsetPair unwrap(byte[] input) {
        ByteBuffer wrap = ByteBuffer.wrap(input).asReadOnlyBuffer();
        byte magic = wrap.get();
        OffsetEncoding decode = OffsetEncoding.decode(magic);
        ByteBuffer slice = wrap.slice();
        return new EncodedOffsetPair(decode, slice);
    }

    public String getDecodedString() {
        String string;
        switch (this.encoding) {
            case ByteArray: {
                string = OffsetSimpleSerialisation.deserialiseByteArrayToBitMapString(this.data);
                break;
            }
            case ByteArrayCompressed: {
                string = OffsetSimpleSerialisation.deserialiseByteArrayToBitMapString(OffsetSimpleSerialisation.decompressZstd(this.data));
                break;
            }
            case BitSet: {
                string = OffsetBitSet.deserialiseBitSetWrap(this.data, OffsetEncoding.Version.v1);
                break;
            }
            case BitSetCompressed: {
                string = OffsetBitSet.deserialiseBitSetWrap(OffsetSimpleSerialisation.decompressZstd(this.data), OffsetEncoding.Version.v1);
                break;
            }
            case RunLength: {
                string = OffsetRunLength.runLengthDecodeToString(OffsetRunLength.runLengthDeserialise(this.data));
                break;
            }
            case RunLengthCompressed: {
                string = OffsetRunLength.runLengthDecodeToString(OffsetRunLength.runLengthDeserialise(OffsetSimpleSerialisation.decompressZstd(this.data)));
                break;
            }
            case BitSetV2: {
                string = OffsetBitSet.deserialiseBitSetWrap(this.data, OffsetEncoding.Version.v2);
                break;
            }
            case BitSetV2Compressed: {
                string = OffsetBitSet.deserialiseBitSetWrap(this.data, OffsetEncoding.Version.v2);
                break;
            }
            case RunLengthV2: {
                string = OffsetBitSet.deserialiseBitSetWrap(this.data, OffsetEncoding.Version.v2);
                break;
            }
            case RunLengthV2Compressed: {
                string = OffsetBitSet.deserialiseBitSetWrap(this.data, OffsetEncoding.Version.v2);
                break;
            }
            default: {
                throw new InternalRuntimeError("Invalid state");
            }
        }
        String binaryArrayString = string;
        return binaryArrayString;
    }

    public OffsetMapCodecManager.HighestOffsetAndIncompletes getDecodedIncompletes(long baseOffset) {
        OffsetMapCodecManager.HighestOffsetAndIncompletes highestOffsetAndIncompletes;
        switch (this.encoding) {
            case BitSet: {
                highestOffsetAndIncompletes = OffsetBitSet.deserialiseBitSetWrapToIncompletes(this.encoding, baseOffset, this.data);
                break;
            }
            case BitSetCompressed: {
                highestOffsetAndIncompletes = OffsetBitSet.deserialiseBitSetWrapToIncompletes(OffsetEncoding.BitSet, baseOffset, OffsetSimpleSerialisation.decompressZstd(this.data));
                break;
            }
            case RunLength: {
                highestOffsetAndIncompletes = OffsetRunLength.runLengthDecodeToIncompletes(this.encoding, baseOffset, this.data);
                break;
            }
            case RunLengthCompressed: {
                highestOffsetAndIncompletes = OffsetRunLength.runLengthDecodeToIncompletes(OffsetEncoding.RunLength, baseOffset, OffsetSimpleSerialisation.decompressZstd(this.data));
                break;
            }
            case BitSetV2: {
                highestOffsetAndIncompletes = OffsetBitSet.deserialiseBitSetWrapToIncompletes(this.encoding, baseOffset, this.data);
                break;
            }
            case BitSetV2Compressed: {
                highestOffsetAndIncompletes = OffsetBitSet.deserialiseBitSetWrapToIncompletes(OffsetEncoding.BitSetV2, baseOffset, OffsetSimpleSerialisation.decompressZstd(this.data));
                break;
            }
            case RunLengthV2: {
                highestOffsetAndIncompletes = OffsetRunLength.runLengthDecodeToIncompletes(this.encoding, baseOffset, this.data);
                break;
            }
            case RunLengthV2Compressed: {
                highestOffsetAndIncompletes = OffsetRunLength.runLengthDecodeToIncompletes(OffsetEncoding.RunLengthV2, baseOffset, OffsetSimpleSerialisation.decompressZstd(this.data));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Encoding (" + this.encoding.description() + ") not supported");
            }
        }
        OffsetMapCodecManager.HighestOffsetAndIncompletes binaryArrayString = highestOffsetAndIncompletes;
        return binaryArrayString;
    }

    public OffsetEncoding getEncoding() {
        return this.encoding;
    }

    public ByteBuffer getData() {
        return this.data;
    }
}

