/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.offsets;

import io.confluent.csid.utils.Range;
import io.confluent.csid.utils.StringUtils;
import io.confluent.parallelconsumer.offsets.BitSetEncoder;
import io.confluent.parallelconsumer.offsets.BitSetEncodingNotSupportedException;
import io.confluent.parallelconsumer.offsets.ByteBufferEncoder;
import io.confluent.parallelconsumer.offsets.EncodedOffsetPair;
import io.confluent.parallelconsumer.offsets.EncodingNotSupportedException;
import io.confluent.parallelconsumer.offsets.NoEncodingPossibleException;
import io.confluent.parallelconsumer.offsets.OffsetEncoder;
import io.confluent.parallelconsumer.offsets.OffsetEncoding;
import io.confluent.parallelconsumer.offsets.RunLengthEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetSimultaneousEncoder {
    private static final Logger log = LoggerFactory.getLogger(OffsetSimultaneousEncoder.class);
    public static final int LARGE_INPUT_MAP_SIZE_THRESHOLD = 200;
    private final Set<Long> incompleteOffsets;
    private final long lowWaterMark;
    private final int length;
    Map<OffsetEncoding, byte[]> encodingMap = new EnumMap<OffsetEncoding, byte[]>(OffsetEncoding.class);
    SortedSet<EncodedOffsetPair> sortedEncodings = new TreeSet<EncodedOffsetPair>();
    public static boolean compressionForced = false;
    public static final String COMPRESSION_FORCED_RESOURCE_LOCK = "Value doesn't matter, just needs a constant";
    private final Set<OffsetEncoder> encoders;

    public OffsetSimultaneousEncoder(long baseOffsetToCommit, long highestSucceededOffset, Set<Long> incompleteOffsets) {
        long bitsetLengthL;
        this.lowWaterMark = baseOffsetToCommit;
        this.incompleteOffsets = incompleteOffsets;
        if (highestSucceededOffset == -1L) {
            highestSucceededOffset = baseOffsetToCommit;
        }
        if ((bitsetLengthL = (highestSucceededOffset = this.maybeRaiseOffsetHighestSucceeded(baseOffsetToCommit, highestSucceededOffset)) - this.lowWaterMark + 1L) < 0L) {
            throw new IllegalStateException(StringUtils.msg("Cannot have negative length BitSet (calculated length: {}, base offset to commit: {}, highest succeeded offset: {})", bitsetLengthL, baseOffsetToCommit, highestSucceededOffset));
        }
        this.length = (int)bitsetLengthL;
        if (bitsetLengthL != (long)this.length) {
            throw new IllegalArgumentException("Integer overflow");
        }
        this.encoders = this.initEncoders();
    }

    private long maybeRaiseOffsetHighestSucceeded(long baseOffsetToCommit, long highestSucceededOffset) {
        boolean gapLargerThanOne;
        long nextExpectedMinusOne = baseOffsetToCommit - 1L;
        boolean bl = gapLargerThanOne = highestSucceededOffset < nextExpectedMinusOne;
        if (gapLargerThanOne) {
            long gap = nextExpectedMinusOne - highestSucceededOffset;
            log.debug("Gap detected in partition (highest succeeded: {} while next expected poll offset: {} - gap is {}), probably tx markers. Moving highest succeeded to next expected - 1", new Object[]{highestSucceededOffset, nextExpectedMinusOne, gap});
            highestSucceededOffset = nextExpectedMinusOne;
        }
        return highestSucceededOffset;
    }

    private Set<OffsetEncoder> initEncoders() {
        HashSet<OffsetEncoder> newEncoders = new HashSet<OffsetEncoder>();
        if (this.length > 200) {
            log.debug("~Large input map size: {} (start: {} end: {})", new Object[]{this.length, this.lowWaterMark, this.lowWaterMark + (long)this.length});
        }
        try {
            newEncoders.add(new BitSetEncoder(this.length, this, OffsetEncoding.Version.v1));
        }
        catch (BitSetEncodingNotSupportedException a) {
            log.debug("Cannot use {} encoder ({})", (Object)BitSetEncoder.class.getSimpleName(), (Object)a.getMessage());
        }
        try {
            newEncoders.add(new BitSetEncoder(this.length, this, OffsetEncoding.Version.v2));
        }
        catch (BitSetEncodingNotSupportedException a) {
            log.warn("Cannot use {} encoder ({})", (Object)BitSetEncoder.class.getSimpleName(), (Object)a.getMessage());
        }
        newEncoders.add(new RunLengthEncoder(this, OffsetEncoding.Version.v1));
        newEncoders.add(new RunLengthEncoder(this, OffsetEncoding.Version.v2));
        return newEncoders;
    }

    void addByteBufferEncoder() {
        this.encoders.add(new ByteBufferEncoder(this.length, this));
    }

    public OffsetSimultaneousEncoder invoke() {
        log.debug("Starting encode of incompletes, base offset is: {}, end offset is: {}", (Object)this.lowWaterMark, (Object)(this.lowWaterMark + (long)this.length));
        log.trace("Incompletes are: {}", this.incompleteOffsets);
        log.debug("Encode loop offset start,end: [{},{}] length: {}", new Object[]{this.lowWaterMark, this.lowWaterMark + (long)this.length, this.length});
        Range.range(this.length).forEach(rangeIndex -> {
            long offset = this.lowWaterMark + (long)rangeIndex.intValue();
            ArrayList removeToBeRemoved = new ArrayList();
            if (this.incompleteOffsets.contains(offset)) {
                log.trace("Found an incomplete offset {}", (Object)offset);
                this.encoders.forEach(x -> x.encodeIncompleteOffset((int)rangeIndex));
            } else {
                this.encoders.forEach(x -> x.encodeCompletedOffset((int)rangeIndex));
            }
            this.encoders.removeAll(removeToBeRemoved);
        });
        this.registerEncodings(this.encoders);
        log.debug("In order: {}", this.sortedEncodings);
        return this;
    }

    private void registerEncodings(Set<? extends OffsetEncoder> encoders) {
        ArrayList<OffsetEncoder> toRemove = new ArrayList<OffsetEncoder>();
        for (OffsetEncoder offsetEncoder : encoders) {
            try {
                offsetEncoder.register();
            }
            catch (EncodingNotSupportedException e) {
                log.debug("Removing {} encoder, not supported ({})", (Object)offsetEncoder.getEncodingType().description(), (Object)e.getMessage());
                toRemove.add(offsetEncoder);
            }
        }
        toRemove.forEach(encoders::remove);
        boolean noEncodingsAreSmallEnough = encoders.stream().noneMatch(OffsetEncoder::quiteSmall);
        if (noEncodingsAreSmallEnough || compressionForced) {
            encoders.forEach(OffsetEncoder::registerCompressed);
        }
    }

    public byte[] packSmallest() throws NoEncodingPossibleException {
        if (this.sortedEncodings.isEmpty()) {
            throw new NoEncodingPossibleException("No encodings could be used");
        }
        EncodedOffsetPair best = this.sortedEncodings.first();
        log.debug("Compression chosen is: {}", (Object)best.encoding.name());
        return this.packEncoding(best);
    }

    byte[] packEncoding(EncodedOffsetPair best) {
        boolean magicByteSize = true;
        ByteBuffer result = ByteBuffer.allocate(1 + best.data.capacity());
        result.put(best.encoding.magicByte);
        result.put(best.data);
        return result.array();
    }

    public Set<Long> getIncompleteOffsets() {
        return this.incompleteOffsets;
    }

    public Map<OffsetEncoding, byte[]> getEncodingMap() {
        return this.encodingMap;
    }

    public SortedSet<EncodedOffsetPair> getSortedEncodings() {
        return this.sortedEncodings;
    }
}

