/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.testcontainers;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import pl.tlinkowski.unij.api.UniLists;

public class FilteredTestContainerSlf4jLogConsumer
extends Slf4jLogConsumer {
    private static final Logger log = LoggerFactory.getLogger(FilteredTestContainerSlf4jLogConsumer.class);
    private List<Level> filteredLevels = UniLists.of((Object)Level.TRACE, (Object)Level.DEBUG);

    public FilteredTestContainerSlf4jLogConsumer(Logger logger) {
        super(logger);
    }

    public FilteredTestContainerSlf4jLogConsumer(Logger logger, boolean separateOutputStreams) {
        super(logger, separateOutputStreams);
    }

    public void accept(OutputFrame outputFrame) {
        if (log.isDebugEnabled()) {
            String utf8String = outputFrame.getUtf8String();
            boolean isFilteredOut = this.filteredLevels.stream().anyMatch(level -> utf8String.contains(level.toString()));
            if (!isFilteredOut) {
                super.accept(outputFrame);
            }
        }
    }

    public List<Level> getFilteredLevels() {
        return this.filteredLevels;
    }

    public void setFilteredLevels(List<Level> filteredLevels) {
        this.filteredLevels = filteredLevels;
    }
}

