/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import com.google.common.truth.Truth;
import io.confluent.csid.utils.TimeUtils;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockedThreadAsserter {
    private static final Logger log = LoggerFactory.getLogger(BlockedThreadAsserter.class);
    private final AtomicBoolean methodReturned = new AtomicBoolean(false);
    final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();

    public boolean functionHasCompleted() {
        return this.methodReturned.get();
    }

    public void assertFunctionBlocks(Runnable functionExpectedToBlock) {
        this.assertFunctionBlocks(functionExpectedToBlock, Duration.ofSeconds(1L));
    }

    public void assertFunctionBlocks(Runnable functionExpectedToBlock, Duration blockedForAtLeast) {
        Thread blocked = new Thread(() -> {
            try {
                log.debug("Running function expected to block for at least {}...", (Object)blockedForAtLeast);
                functionExpectedToBlock.run();
                log.debug("Blocked function finished.");
            }
            catch (Exception e) {
                log.error("Error in blocking function", (Throwable)e);
            }
            this.methodReturned.set(true);
        });
        blocked.start();
        Awaitility.await().pollDelay(blockedForAtLeast).atMost(blockedForAtLeast.plus(Duration.ofSeconds(1L))).untilAsserted(() -> Truth.assertWithMessage((String)"Thread should be sleeping/blocked and not have returned").that(Boolean.valueOf(this.methodReturned.get())).isFalse());
    }

    public void assertUnblocksAfter(Runnable functionExpectedToBlock, Runnable unblockingFunction, Duration unblocksAfter) {
        AtomicBoolean unblockerHasRun = new AtomicBoolean(false);
        this.scheduledExecutorService.schedule(() -> {
            log.debug("Running unblocking function - blocked function should return ONLY after this (which will be tested)");
            try {
                unblockingFunction.run();
            }
            catch (Exception e) {
                log.error("Error in unlocking function", (Throwable)e);
            }
            unblockerHasRun.set(true);
            log.debug("Blocked function returned");
        }, unblocksAfter.toMillis(), TimeUnit.MILLISECONDS);
        TimeUtils.TimeResult time = TimeUtils.timeWithMeta(() -> {
            log.debug("Running function expected to block for at least {}...", (Object)unblocksAfter);
            try {
                functionExpectedToBlock.run();
            }
            catch (Exception e) {
                log.error("Error in blocking function", (Throwable)e);
            }
            log.debug("Unblocking function finished returned");
            return Void.class;
        });
        log.debug("Function unblocked after {}", (Object)time.getElapsed());
        this.methodReturned.set(true);
        Truth.assertThat((Comparable)time.getElapsed()).isAtLeast((Comparable)unblocksAfter);
        Truth.assertWithMessage((String)"Unblocking function should complete OK (if false, may not have run at all - or that the expected function to block did NOT block)").that(Boolean.valueOf(unblockerHasRun.get())).isTrue();
    }

    public void assertUnblocksAfter(Runnable functionExpectedToBlock, Runnable unblockingFunction) {
        this.assertUnblocksAfter(functionExpectedToBlock, unblockingFunction, Duration.ofSeconds(1L));
    }

    public void awaitReturnFully() {
        log.debug("Waiting for blocked method to fully finish...");
        Awaitility.await().untilTrue(this.methodReturned);
        log.debug("Waiting on blocked method to fully finish is complete.");
    }
}

