/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import io.confluent.csid.utils.LongPollingMockConsumer;
import io.confluent.csid.utils.Range;
import io.confluent.parallelconsumer.PollContext;
import io.confluent.parallelconsumer.state.WorkContainer;
import io.confluent.parallelconsumer.state.WorkManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.common.TopicPartition;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTestUtils {
    private static final Logger log = LoggerFactory.getLogger(KafkaTestUtils.class);
    private final String INPUT_TOPIC;
    private final String CONSUMER_GROUP_ID;
    private final LongPollingMockConsumer consumerSpy;
    int offset = 0;
    private List<Integer> defaultKeys = Range.listOfIntegers((int)100);

    public void assignConsumerToTopic(MockConsumer mc) {
        TopicPartition tp1 = new TopicPartition(this.INPUT_TOPIC, 1);
        TopicPartition tp0 = new TopicPartition(this.INPUT_TOPIC, 0);
        mc.assign((Collection)Lists.list((Object[])new TopicPartition[]{tp0, tp1}));
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(tp0, 0L);
        beginningOffsets.put(tp1, 0L);
        mc.updateBeginningOffsets(beginningOffsets);
    }

    public static List<Integer> trimAllGenesisOffset(List<Integer> collect) {
        return collect.stream().filter(x -> x != 0).collect(Collectors.toList());
    }

    public ConsumerRecord<String, String> makeRecord(String key, String value) {
        return this.makeRecord(0, key, value);
    }

    public ConsumerRecord<String, String> makeRecord(int part, String key, String value) {
        ConsumerRecord stringStringConsumerRecord = new ConsumerRecord(this.INPUT_TOPIC, part, (long)this.offset, (Object)key, (Object)value);
        ++this.offset;
        return stringStringConsumerRecord;
    }

    public void assertCommits(MockProducer mp, List<Integer> integers) {
        this.assertCommits(mp, integers, Optional.empty());
    }

    public void assertCommits(MockProducer mp, List<Integer> expectedOffsets, Optional<String> description) {
        log.debug("Asserting commits of {}", expectedOffsets);
        List<Integer> offsets = this.getProducerCommitsFlattened(mp);
        if (!expectedOffsets.contains(0)) {
            offsets = KafkaTestUtils.trimAllGenesisOffset(offsets);
        }
        ((ListAssert)Assertions.assertThat(offsets).describedAs(description.orElse("Which offsets are committed and in the expected order"), new Object[0])).containsExactlyElementsOf(expectedOffsets);
    }

    public List<Integer> getProducerCommitsFlattened(MockProducer mp) {
        return this.getProducerCommitsMeta(mp).stream().map(x -> (int)x.offset()).collect(Collectors.toList());
    }

    public List<OffsetAndMetadata> getProducerCommitsMeta(MockProducer mp) {
        List history = mp.consumerGroupOffsetsHistory();
        List<OffsetAndMetadata> set = history.stream().flatMap(histories -> {
            ArrayList<OffsetAndMetadata> results = new ArrayList<OffsetAndMetadata>();
            Map group = (Map)histories.get(this.CONSUMER_GROUP_ID);
            for (Map.Entry partitionOffsets : group.entrySet()) {
                OffsetAndMetadata commit = (OffsetAndMetadata)partitionOffsets.getValue();
                results.add(commit);
            }
            return results.stream();
        }).collect(Collectors.toList());
        return set;
    }

    public void assertCommitLists(MockProducer mp, List<List<Integer>> expectedPartitionOffsets, Optional<String> description) {
        this.assertCommitLists(mp.consumerGroupOffsetsHistory(), expectedPartitionOffsets, description);
    }

    public void assertCommitLists(List<Map<String, Map<TopicPartition, OffsetAndMetadata>>> history, List<List<Integer>> expectedPartitionOffsets, Optional<String> description) {
        log.info("Asserting commits of {}", expectedPartitionOffsets);
        AtomicReference<String> topicName = new AtomicReference<String>("");
        HashMap partitionToCommittedOffsets = new HashMap();
        new ArrayList<Map<String, Map<TopicPartition, OffsetAndMetadata>>>(history).stream().forEachOrdered(histories -> {
            Map partitionCommits = (Map)histories.get(this.CONSUMER_GROUP_ID);
            Set entries = partitionCommits.entrySet();
            ArrayList wrapped = new ArrayList(entries);
            for (Map.Entry singlePartitionCommit : wrapped) {
                TopicPartition key = (TopicPartition)singlePartitionCommit.getKey();
                topicName.set(key.topic());
                OffsetAndMetadata commit = (OffsetAndMetadata)singlePartitionCommit.getValue();
                int offset = (int)commit.offset();
                partitionToCommittedOffsets.computeIfAbsent(key, x -> new HashSet());
                if (offset == 0) continue;
                ((Set)partitionToCommittedOffsets.get(key)).add(offset);
            }
        });
        HashMap<TopicPartition, HashSet<Integer>> expectedMap = new HashMap<TopicPartition, HashSet<Integer>>();
        for (int i = 0; i < expectedPartitionOffsets.size(); ++i) {
            List<Integer> offsets = expectedPartitionOffsets.get(i);
            TopicPartition tp = new TopicPartition(topicName.get(), i);
            expectedMap.put(tp, new HashSet<Integer>(offsets));
        }
        ((MapAssert)Assertions.assertThat(partitionToCommittedOffsets).describedAs(description.orElse("Which offsets are committed and in the expected order"), new Object[0])).containsExactlyEntriesOf(expectedMap);
    }

    public static void assertLastCommitIs(LongPollingMockConsumer<String, String> mockConsumer, int expected) {
        CopyOnWriteArrayList<Map<TopicPartition, OffsetAndMetadata>> commits = mockConsumer.getCommitHistoryInt();
        Assertions.assertThat(commits).isNotEmpty();
        long offset = (int)((OffsetAndMetadata)((Map)commits.get(commits.size() - 1)).values().iterator().next()).offset();
        Assertions.assertThat((long)offset).isEqualTo((long)expected);
    }

    public List<ConsumerRecord<String, String>> generateRecords(int quantity) {
        HashMap<Integer, List<ConsumerRecord<String, String>>> integerListHashMap = this.generateRecords(this.defaultKeys, quantity);
        Collection values = integerListHashMap.values();
        return this.flatten(values);
    }

    public HashMap<Integer, List<ConsumerRecord<String, String>>> generateRecords(List<Integer> keys, int quantity) {
        HashMap<Integer, List<ConsumerRecord<String, String>>> keyRecords = new HashMap<Integer, List<ConsumerRecord<String, String>>>(quantity);
        for (int globalCount = 0; globalCount < quantity; ++globalCount) {
            Integer key = this.getRandomKey(keys);
            int recsCountForThisKey = (int)(Math.random() * (double)quantity);
            String keyString = key.toString();
            List keyList = keyRecords.computeIfAbsent(key, ignore -> new ArrayList());
            int keyCount = keyList.size();
            String value = keyCount + "," + globalCount;
            ConsumerRecord<String, String> rec = this.makeRecord(keyString, value);
            keyList.add(rec);
        }
        return keyRecords;
    }

    private Integer removeRandomKey(List<Integer> keyWork) {
        int i = (int)(Math.random() * (double)keyWork.size());
        Integer remove = keyWork.remove(i);
        return remove;
    }

    public ArrayList<ConsumerRecord<String, String>> generateRecordsForKey(Integer key, int quantity) {
        ArrayList<ConsumerRecord<String, String>> records = new ArrayList<ConsumerRecord<String, String>>(quantity);
        Iterator iterator = Range.range((long)quantity).iterator();
        while (iterator.hasNext()) {
            long i = (Long)iterator.next();
            ConsumerRecord<String, String> rec = this.makeRecord(key.toString(), i + "");
            records.add(rec);
        }
        return records;
    }

    public <KEY, VALUE> List<ConsumerRecord<KEY, VALUE>> flatten(Collection<List<ConsumerRecord<KEY, VALUE>>> listlist) {
        TreeSet<ConsumerRecord> all = new TreeSet<ConsumerRecord>(Comparator.comparing(ConsumerRecord::offset));
        for (Collection collection : listlist) {
            all.addAll(collection);
        }
        return new ArrayList<ConsumerRecord<KEY, VALUE>>(all);
    }

    private Integer getRandomDefaultKey() {
        int i = (int)(Math.random() * (double)this.defaultKeys.size());
        return this.defaultKeys.get(i);
    }

    private Integer getRandomKey(List<Integer> keyList) {
        int i = (int)(Math.random() * (double)keyList.size());
        return keyList.get(i);
    }

    private ConsumerRecord<String, String> addRecord(String k, String v) {
        ConsumerRecord<String, String> record = this.makeRecord(k, v);
        this.consumerSpy.addRecord(record);
        return record;
    }

    public void send(MockConsumer<String, String> consumerSpy, HashMap<?, List<ConsumerRecord<String, String>>> records) {
        List<ConsumerRecord<String, String>> collect = records.entrySet().stream().flatMap(x -> ((List)x.getValue()).stream()).collect(Collectors.toList());
        this.send(consumerSpy, collect);
    }

    public void send(MockConsumer<String, String> consumerSpy, List<ConsumerRecord<String, String>> records) {
        log.debug("Sending {} more messages to the consumer stub", (Object)records.size());
        ArrayList<ConsumerRecord<String, String>> sorted = new ArrayList<ConsumerRecord<String, String>>(records);
        sorted.sort(Comparator.comparingLong(ConsumerRecord::offset));
        for (ConsumerRecord consumerRecord : sorted) {
            consumerSpy.addRecord(consumerRecord);
        }
    }

    public static void completeWork(WorkManager<String, String> wmm, List<WorkContainer<String, String>> work, long offset) {
        WorkContainer workMatchingProvidedOffset = work.stream().filter(x -> x.getCr().offset() == offset).findFirst().get();
        KafkaTestUtils.completeWork(wmm, (WorkContainer<String, String>)workMatchingProvidedOffset);
    }

    public static void completeWork(WorkManager<String, String> wmm, WorkContainer<String, String> wc) {
        FutureTask<Boolean> future = new FutureTask<Boolean>(() -> true);
        future.run();
        Assertions.assertThat(future).isDone();
        wc.setFuture(future);
        wc.onUserFunctionSuccess();
        wmm.onSuccessResult(wc);
        Assertions.assertThat((boolean)wc.isUserFunctionComplete()).isTrue();
    }

    public List<ConsumerRecord<String, String>> sendRecords(int i) {
        List<ConsumerRecord<String, String>> consumerRecords = this.generateRecords(i);
        this.send((MockConsumer<String, String>)this.consumerSpy, consumerRecords);
        return consumerRecords;
    }

    public static <T> void checkExactOrdering(Map<String, Queue<PollContext<String, String>>> results, HashMap<Integer, List<T>> originalRecords) {
        originalRecords.entrySet().forEach(entry -> {
            List originalRecordList = (List)entry.getValue();
            Integer originalKey = (Integer)entry.getKey();
            Queue sequence = (Queue)results.get(originalKey.toString());
            Assertions.assertThat((Collection)sequence).hasSameSizeAs((Iterable)originalRecordList);
            ((AbstractIntegerAssert)Assertions.assertThat((int)sequence.size()).describedAs("Sanity: is same size as original list", new Object[0])).isEqualTo(originalRecordList.size());
            log.debug("Key {} has same size of record as original - {}", (Object)originalKey, (Object)sequence.size());
            PollContext last = (PollContext)sequence.poll();
            PollContext next = null;
            while (!sequence.isEmpty()) {
                next = (PollContext)sequence.poll();
                int thisValue = Integer.parseInt(StringUtils.substringBefore((String)((String)next.value()), (String)","));
                int lastValuePlusOne = Integer.parseInt(StringUtils.substringBefore((String)((String)last.value()), (String)",")) + 1;
                Assertions.assertThat((int)thisValue).isEqualTo(lastValuePlusOne);
                last = next;
            }
            log.debug("Key {} a an exactly sequential series of values, ending in {} (starts at zero)", (Object)originalKey, next.value());
        });
    }

    public KafkaTestUtils(String INPUT_TOPIC, String CONSUMER_GROUP_ID, LongPollingMockConsumer consumerSpy) {
        this.INPUT_TOPIC = INPUT_TOPIC;
        this.CONSUMER_GROUP_ID = CONSUMER_GROUP_ID;
        this.consumerSpy = consumerSpy;
    }

    public LongPollingMockConsumer getConsumerSpy() {
        return this.consumerSpy;
    }

    public void setDefaultKeys(List<Integer> defaultKeys) {
        this.defaultKeys = defaultKeys;
    }

    public List<Integer> getDefaultKeys() {
        return this.defaultKeys;
    }
}

