/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import io.confluent.csid.utils.BackportUtils;
import io.confluent.csid.utils.Range;
import io.confluent.parallelconsumer.ParallelEoSStreamProcessorTestBase;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatchTestUtils {
    private static final Logger log = LoggerFactory.getLogger(LatchTestUtils.class);

    public static void awaitLatch(List<CountDownLatch> latches, int latchIndex) {
        log.trace("Waiting on latch {}", (Object)latchIndex);
        LatchTestUtils.awaitLatch(latches.get(latchIndex));
        log.trace("Wait on latch {} finished.", (Object)latchIndex);
    }

    public static void awaitLatch(CountDownLatch latch) {
        LatchTestUtils.awaitLatch(latch, ParallelEoSStreamProcessorTestBase.defaultTimeoutSeconds);
    }

    public static void awaitLatch(CountDownLatch latch, int seconds) {
        log.trace("Waiting on latch with timeout {}s", (Object)seconds);
        Instant start = Instant.now();
        boolean latchReachedZero = false;
        while (start.isAfter(Instant.now().minusSeconds(seconds))) {
            try {
                latchReachedZero = latch.await(seconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.trace("Latch await interrupted", (Throwable)e);
            }
            if (latchReachedZero) break;
            log.trace("Latch wait aborted, but timeout ({}s) not reached - will try to wait again remaining {}", (Object)seconds, (Object)((long)seconds - BackportUtils.toSeconds((Duration)Duration.between(start, Instant.now()))));
        }
        if (!latchReachedZero) {
            throw new TimeoutException("Latch await timeout (" + seconds + " seconds) - " + latch.getCount() + " count remaining");
        }
        log.trace("Latch was released (#countdown)");
    }

    public static void release(List<CountDownLatch> locks, int lockIndex) {
        log.debug("Releasing {}...", (Object)lockIndex);
        locks.get(lockIndex).countDown();
    }

    public static List<CountDownLatch> constructLatches(int numberOfLatches) {
        ArrayList<CountDownLatch> result = new ArrayList<CountDownLatch>(numberOfLatches);
        for (Long ignore : Range.range((long)numberOfLatches)) {
            result.add(new CountDownLatch(1));
        }
        return result;
    }

    public static void release(CountDownLatch latch) {
        log.info("Latch countdown");
        latch.countDown();
    }
}

